/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.plugin.m2repo.impl.scanner;

import com.buschmais.jqassistant.plugin.m2repo.api.ArtifactProvider;
import com.buschmais.jqassistant.plugin.maven3.api.scanner.PomModelBuilder;
import com.buschmais.jqassistant.plugin.maven3.api.scanner.RawModelBuilder;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import org.apache.maven.model.Build;
import org.apache.maven.model.CiManagement;
import org.apache.maven.model.Contributor;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.model.Developer;
import org.apache.maven.model.DistributionManagement;
import org.apache.maven.model.InputLocation;
import org.apache.maven.model.IssueManagement;
import org.apache.maven.model.License;
import org.apache.maven.model.MailingList;
import org.apache.maven.model.Model;
import org.apache.maven.model.Organization;
import org.apache.maven.model.Parent;
import org.apache.maven.model.Prerequisites;
import org.apache.maven.model.Profile;
import org.apache.maven.model.Reporting;
import org.apache.maven.model.Repository;
import org.apache.maven.model.Scm;
import org.apache.maven.model.building.DefaultModelBuilder;
import org.apache.maven.model.building.DefaultModelBuilderFactory;
import org.apache.maven.model.building.DefaultModelBuildingRequest;
import org.apache.maven.model.building.FileModelSource;
import org.apache.maven.model.building.ModelBuildingException;
import org.apache.maven.model.building.ModelBuildingRequest;
import org.apache.maven.model.building.ModelProblemCollector;
import org.apache.maven.model.building.ModelProblemCollectorExt;
import org.apache.maven.model.building.ModelSource;
import org.apache.maven.model.resolution.InvalidRepositoryException;
import org.apache.maven.model.resolution.ModelResolver;
import org.apache.maven.model.resolution.UnresolvableModelException;
import org.apache.maven.model.validation.ModelValidator;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.ArtifactResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EffectiveModelBuilder
implements PomModelBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(EffectiveModelBuilder.class);
    private ModelResolverImpl modelResolver;
    private RawModelBuilder rawModelBuilder;

    public EffectiveModelBuilder(ArtifactProvider artifactProvider) {
        this.modelResolver = new ModelResolverImpl(artifactProvider);
        this.rawModelBuilder = new RawModelBuilder();
    }

    public Model getModel(File pomFile) throws IOException {
        DefaultModelBuilder builder = new DefaultModelBuilderFactory().newInstance();
        DefaultModelBuildingRequest req = new DefaultModelBuildingRequest();
        req.setProcessPlugins(false);
        req.setPomFile(pomFile);
        req.setModelResolver((ModelResolver)this.modelResolver);
        req.setValidationLevel(0);
        req.setSystemProperties(System.getProperties());
        builder.setModelValidator((ModelValidator)new ModelValidatorImpl());
        try {
            return builder.build((ModelBuildingRequest)req).getEffectiveModel();
        }
        catch (ModelBuildingException e) {
            LOGGER.warn("Cannot build effective model for " + pomFile.getAbsolutePath(), (Throwable)e);
            return new EffectiveModel(this.rawModelBuilder.getModel(pomFile));
        }
    }

    private static class EffectiveModel
    extends Model {
        private Model delegate;

        public EffectiveModel(Model delegate) {
            this.delegate = delegate;
        }

        public void addContributor(Contributor contributor) {
            this.delegate.addContributor(contributor);
        }

        public void addDeveloper(Developer developer) {
            this.delegate.addDeveloper(developer);
        }

        public void addLicense(License license) {
            this.delegate.addLicense(license);
        }

        public void addMailingList(MailingList mailingList) {
            this.delegate.addMailingList(mailingList);
        }

        public void addProfile(Profile profile) {
            this.delegate.addProfile(profile);
        }

        public Model clone() {
            return this.delegate.clone();
        }

        public String getArtifactId() {
            return this.delegate.getArtifactId();
        }

        public Build getBuild() {
            return this.delegate.getBuild();
        }

        public CiManagement getCiManagement() {
            return this.delegate.getCiManagement();
        }

        public List<Contributor> getContributors() {
            return this.delegate.getContributors();
        }

        public String getDescription() {
            return this.delegate.getDescription();
        }

        public List<Developer> getDevelopers() {
            return this.delegate.getDevelopers();
        }

        public String getGroupId() {
            return this.delegate.getGroupId() != null ? this.delegate.getGroupId() : this.getParent().getGroupId();
        }

        public String getInceptionYear() {
            return this.delegate.getInceptionYear();
        }

        public IssueManagement getIssueManagement() {
            return this.delegate.getIssueManagement();
        }

        public List<License> getLicenses() {
            return this.delegate.getLicenses();
        }

        public List<MailingList> getMailingLists() {
            return this.delegate.getMailingLists();
        }

        public String getModelEncoding() {
            return this.delegate.getModelEncoding();
        }

        public String getModelVersion() {
            return this.delegate.getModelVersion();
        }

        public String getName() {
            return this.delegate.getName();
        }

        public Organization getOrganization() {
            return this.delegate.getOrganization();
        }

        public String getPackaging() {
            return this.delegate.getPackaging();
        }

        public Parent getParent() {
            return this.delegate.getParent();
        }

        public Prerequisites getPrerequisites() {
            return this.delegate.getPrerequisites();
        }

        public List<Profile> getProfiles() {
            return this.delegate.getProfiles();
        }

        public Scm getScm() {
            return this.delegate.getScm();
        }

        public String getUrl() {
            return this.delegate.getUrl();
        }

        public String getVersion() {
            return this.delegate.getVersion() != null ? this.delegate.getVersion() : this.getParent().getVersion();
        }

        public void removeContributor(Contributor contributor) {
            this.delegate.removeContributor(contributor);
        }

        public void removeDeveloper(Developer developer) {
            this.delegate.removeDeveloper(developer);
        }

        public void removeLicense(License license) {
            this.delegate.removeLicense(license);
        }

        public void removeMailingList(MailingList mailingList) {
            this.delegate.removeMailingList(mailingList);
        }

        public void removeProfile(Profile profile) {
            this.delegate.removeProfile(profile);
        }

        public void setArtifactId(String artifactId) {
            this.delegate.setArtifactId(artifactId);
        }

        public void setBuild(Build build) {
            this.delegate.setBuild(build);
        }

        public void setCiManagement(CiManagement ciManagement) {
            this.delegate.setCiManagement(ciManagement);
        }

        public void setContributors(List<Contributor> contributors) {
            this.delegate.setContributors(contributors);
        }

        public void setDescription(String description) {
            this.delegate.setDescription(description);
        }

        public void setDevelopers(List<Developer> developers) {
            this.delegate.setDevelopers(developers);
        }

        public void setGroupId(String groupId) {
            this.delegate.setGroupId(groupId);
        }

        public void setInceptionYear(String inceptionYear) {
            this.delegate.setInceptionYear(inceptionYear);
        }

        public void setIssueManagement(IssueManagement issueManagement) {
            this.delegate.setIssueManagement(issueManagement);
        }

        public void setLicenses(List<License> licenses) {
            this.delegate.setLicenses(licenses);
        }

        public void setMailingLists(List<MailingList> mailingLists) {
            this.delegate.setMailingLists(mailingLists);
        }

        public void setModelEncoding(String modelEncoding) {
            this.delegate.setModelEncoding(modelEncoding);
        }

        public void setModelVersion(String modelVersion) {
            this.delegate.setModelVersion(modelVersion);
        }

        public void setName(String name) {
            this.delegate.setName(name);
        }

        public void setOrganization(Organization organization) {
            this.delegate.setOrganization(organization);
        }

        public void setPackaging(String packaging) {
            this.delegate.setPackaging(packaging);
        }

        public void setParent(Parent parent) {
            this.delegate.setParent(parent);
        }

        public void setPrerequisites(Prerequisites prerequisites) {
            this.delegate.setPrerequisites(prerequisites);
        }

        public void setProfiles(List<Profile> profiles) {
            this.delegate.setProfiles(profiles);
        }

        public void setScm(Scm scm) {
            this.delegate.setScm(scm);
        }

        public void setUrl(String url) {
            this.delegate.setUrl(url);
        }

        public void setVersion(String version) {
            this.delegate.setVersion(version);
        }

        public File getPomFile() {
            return this.delegate.getPomFile();
        }

        public void setPomFile(File pomFile) {
            this.delegate.setPomFile(pomFile);
        }

        public File getProjectDirectory() {
            return this.delegate.getProjectDirectory();
        }

        public void addDependency(Dependency dependency) {
            this.delegate.addDependency(dependency);
        }

        public void addModule(String string) {
            this.delegate.addModule(string);
        }

        public void addPluginRepository(Repository repository) {
            this.delegate.addPluginRepository(repository);
        }

        public void addProperty(String key, String value) {
            this.delegate.addProperty(key, value);
        }

        public void addRepository(Repository repository) {
            this.delegate.addRepository(repository);
        }

        public List<Dependency> getDependencies() {
            return this.delegate.getDependencies();
        }

        public DependencyManagement getDependencyManagement() {
            return this.delegate.getDependencyManagement();
        }

        public DistributionManagement getDistributionManagement() {
            return this.delegate.getDistributionManagement();
        }

        public InputLocation getLocation(Object key) {
            return this.delegate.getLocation(key);
        }

        public List<String> getModules() {
            return this.delegate.getModules();
        }

        public List<Repository> getPluginRepositories() {
            return this.delegate.getPluginRepositories();
        }

        public Properties getProperties() {
            return this.delegate.getProperties();
        }

        public Reporting getReporting() {
            return this.delegate.getReporting();
        }

        public Object getReports() {
            return this.delegate.getReports();
        }

        public List<Repository> getRepositories() {
            return this.delegate.getRepositories();
        }

        public void removeDependency(Dependency dependency) {
            this.delegate.removeDependency(dependency);
        }

        public void removeModule(String string) {
            this.delegate.removeModule(string);
        }

        public void removePluginRepository(Repository repository) {
            this.delegate.removePluginRepository(repository);
        }

        public void removeRepository(Repository repository) {
            this.delegate.removeRepository(repository);
        }

        public void setDependencies(List<Dependency> dependencies) {
            this.delegate.setDependencies(dependencies);
        }

        public void setDependencyManagement(DependencyManagement dependencyManagement) {
            this.delegate.setDependencyManagement(dependencyManagement);
        }

        public void setDistributionManagement(DistributionManagement distributionManagement) {
            this.delegate.setDistributionManagement(distributionManagement);
        }

        public void setLocation(Object key, InputLocation location) {
            this.delegate.setLocation(key, location);
        }

        public void setModules(List<String> modules) {
            this.delegate.setModules(modules);
        }

        public void setPluginRepositories(List<Repository> pluginRepositories) {
            this.delegate.setPluginRepositories(pluginRepositories);
        }

        public void setProperties(Properties properties) {
            this.delegate.setProperties(properties);
        }

        public void setReporting(Reporting reporting) {
            this.delegate.setReporting(reporting);
        }

        public void setReports(Object reports) {
            this.delegate.setReports(reports);
        }

        public void setRepositories(List<Repository> repositories) {
            this.delegate.setRepositories(repositories);
        }
    }

    public class ModelResolverImpl
    implements ModelResolver {
        private ArtifactProvider artifactProvider;

        public ModelResolverImpl(ArtifactProvider artifactProvider) {
            this.artifactProvider = artifactProvider;
        }

        public ModelSource resolveModel(String groupId, String artifactId, String version) throws UnresolvableModelException {
            ArtifactResult artifactResult;
            DefaultArtifact artifact = new DefaultArtifact(groupId, artifactId, null, "pom", version);
            try {
                artifactResult = this.artifactProvider.getArtifact((Artifact)artifact);
            }
            catch (ArtifactResolutionException e) {
                throw new UnresolvableModelException("Cannot resolve artifact.", groupId, artifactId, version, (Throwable)e);
            }
            File file = artifactResult.getArtifact().getFile();
            return new FileModelSource(file);
        }

        public void addRepository(Repository repository) throws InvalidRepositoryException {
        }

        public ModelResolver newCopy() {
            return new ModelResolverImpl(this.artifactProvider);
        }
    }

    private static class ModelValidatorImpl
    implements ModelValidator {
        private ModelValidatorImpl() {
        }

        public void validateRawModel(Model model, ModelBuildingRequest request, ModelProblemCollector problems) {
        }

        public void validateEffectiveModel(Model model, ModelBuildingRequest request, ModelProblemCollector problems) {
            if (problems instanceof ModelProblemCollectorExt) {
                this.clearProblems(problems, "problems", true);
                this.clearProblems(problems, "severities", false);
            }
        }

        private void clearProblems(ModelProblemCollector problems, String field, boolean logValue) {
            try {
                Field problemsList = problems.getClass().getDeclaredField(field);
                problemsList.setAccessible(true);
                Collection value = (Collection)problemsList.get(problems);
                if (!value.isEmpty()) {
                    if (logValue) {
                        LOGGER.warn("Problems have been detected while validating POM model: {}.", (Object)value);
                    }
                    value.clear();
                }
            }
            catch (NoSuchFieldException e) {
                LOGGER.warn("Cannot find field " + field, (Throwable)e);
            }
            catch (IllegalAccessException e) {
                LOGGER.warn("Cannot access field " + field, (Throwable)e);
            }
        }
    }
}

