/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.plugin.cdi.impl.scanner;

import com.buschmais.jqassistant.core.scanner.api.Scanner;
import com.buschmais.jqassistant.core.scanner.api.ScannerContext;
import com.buschmais.jqassistant.core.scanner.api.ScannerPlugin;
import com.buschmais.jqassistant.core.scanner.api.Scope;
import com.buschmais.jqassistant.core.store.api.model.Descriptor;
import com.buschmais.jqassistant.plugin.cdi.api.model.BeansXmlDescriptor;
import com.buschmais.jqassistant.plugin.common.api.model.FileDescriptor;
import com.buschmais.jqassistant.plugin.common.api.scanner.AbstractScannerPlugin;
import com.buschmais.jqassistant.plugin.common.api.scanner.filesystem.FileResource;
import com.buschmais.jqassistant.plugin.java.api.model.TypeDescriptor;
import com.buschmais.jqassistant.plugin.java.api.scanner.JavaScope;
import com.buschmais.jqassistant.plugin.java.api.scanner.TypeResolver;
import com.buschmais.jqassistant.plugin.xml.api.model.XmlFileDescriptor;
import com.buschmais.jqassistant.plugin.xml.api.scanner.JAXBUnmarshaller;
import com.buschmais.jqassistant.plugin.xml.api.scanner.XmlScope;
import java.io.IOException;
import java.util.List;
import javax.xml.bind.JAXBElement;
import org.jcp.xmlns.xml.ns.javaee.Alternatives;
import org.jcp.xmlns.xml.ns.javaee.Beans;
import org.jcp.xmlns.xml.ns.javaee.Decorators;
import org.jcp.xmlns.xml.ns.javaee.Interceptors;

@ScannerPlugin.Requires(value={FileDescriptor.class})
public class BeansXmlScannerPlugin
extends AbstractScannerPlugin<FileResource, BeansXmlDescriptor> {
    private JAXBUnmarshaller<FileResource, Beans> unmarshaller;

    public void initialize() {
        this.unmarshaller = new JAXBUnmarshaller(Beans.class);
    }

    public boolean accepts(FileResource item, String path, Scope scope) throws IOException {
        return JavaScope.CLASSPATH.equals((Object)scope) && ("/META-INF/beans.xml".equals(path) || "/WEB-INF/beans.xml".equals(path));
    }

    public BeansXmlDescriptor scan(FileResource item, String path, Scope scope, Scanner scanner) throws IOException {
        ScannerContext context = scanner.getContext();
        XmlFileDescriptor xmlFileDescriptor = (XmlFileDescriptor)scanner.scan((Object)item, path, (Scope)XmlScope.DOCUMENT);
        BeansXmlDescriptor beansXmlDescriptor = (BeansXmlDescriptor)context.getStore().addDescriptorType((Descriptor)xmlFileDescriptor, BeansXmlDescriptor.class);
        Beans beans = (Beans)this.unmarshaller.unmarshal(item);
        beansXmlDescriptor.setVersion(beans.getVersion());
        beansXmlDescriptor.setBeanDiscoveryMode(beans.getBeanDiscoveryMode());
        for (Object o : beans.getInterceptorsOrDecoratorsOrAlternatives()) {
            if (o instanceof Interceptors) {
                this.addTypes(((Interceptors)o).getClazz(), beansXmlDescriptor.getInterceptors(), context);
                continue;
            }
            if (o instanceof Decorators) {
                this.addTypes(((Decorators)o).getClazz(), beansXmlDescriptor.getDecorators(), context);
                continue;
            }
            if (!(o instanceof Alternatives)) continue;
            List<JAXBElement<String>> clazzOrStereotype = ((Alternatives)o).getClazzOrStereotype();
            for (JAXBElement<String> element : clazzOrStereotype) {
                TypeDescriptor alternative = ((TypeResolver)scanner.getContext().peek(TypeResolver.class)).resolve((String)element.getValue(), context).getTypeDescriptor();
                beansXmlDescriptor.getAlternatives().add(alternative);
            }
        }
        return beansXmlDescriptor;
    }

    private void addTypes(List<String> typeNames, List<TypeDescriptor> types, ScannerContext scannerContext) {
        for (String typeName : typeNames) {
            TypeDescriptor type = ((TypeResolver)scannerContext.peek(TypeResolver.class)).resolve(typeName, scannerContext).getTypeDescriptor();
            types.add(type);
        }
    }
}

