/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.core.report.impl;

import com.buschmais.jqassistant.core.analysis.api.AnalysisListener;
import com.buschmais.jqassistant.core.analysis.api.AnalysisListenerException;
import com.buschmais.jqassistant.core.analysis.api.Result;
import com.buschmais.jqassistant.core.analysis.api.rule.Concept;
import com.buschmais.jqassistant.core.analysis.api.rule.Constraint;
import com.buschmais.jqassistant.core.analysis.api.rule.ExecutableRule;
import com.buschmais.jqassistant.core.analysis.api.rule.Group;

public class CompositeReportWriter
implements AnalysisListener<AnalysisListenerException> {
    private Iterable<AnalysisListener> reportWriters;

    public CompositeReportWriter(Iterable<AnalysisListener> reportWriters) {
        this.reportWriters = reportWriters;
    }

    public void begin() throws AnalysisListenerException {
        this.run(new DelegateOperation(){

            @Override
            public void run(AnalysisListener reportWriter) throws AnalysisListenerException {
                reportWriter.begin();
            }
        });
    }

    public void end() throws AnalysisListenerException {
        this.run(new DelegateOperation(){

            @Override
            public void run(AnalysisListener reportWriter) throws AnalysisListenerException {
                reportWriter.end();
            }
        });
    }

    public void beginConcept(final Concept concept) throws AnalysisListenerException {
        this.run(new DelegateOperation(){

            @Override
            public void run(AnalysisListener reportWriter) throws AnalysisListenerException {
                reportWriter.beginConcept(concept);
            }
        });
    }

    public void endConcept() throws AnalysisListenerException {
        this.run(new DelegateOperation(){

            @Override
            public void run(AnalysisListener reportWriter) throws AnalysisListenerException {
                reportWriter.endConcept();
            }
        });
    }

    public void beginGroup(final Group group) throws AnalysisListenerException {
        this.run(new DelegateOperation(){

            @Override
            public void run(AnalysisListener reportWriter) throws AnalysisListenerException {
                reportWriter.beginGroup(group);
            }
        });
    }

    public void endGroup() throws AnalysisListenerException {
        this.run(new DelegateOperation(){

            @Override
            public void run(AnalysisListener reportWriter) throws AnalysisListenerException {
                reportWriter.endGroup();
            }
        });
    }

    public void beginConstraint(final Constraint constraint) throws AnalysisListenerException {
        this.run(new DelegateOperation(){

            @Override
            public void run(AnalysisListener reportWriter) throws AnalysisListenerException {
                reportWriter.beginConstraint(constraint);
            }
        });
    }

    public void endConstraint() throws AnalysisListenerException {
        this.run(new DelegateOperation(){

            @Override
            public void run(AnalysisListener reportWriter) throws AnalysisListenerException {
                reportWriter.endConstraint();
            }
        });
    }

    public void setResult(final Result<? extends ExecutableRule> result) throws AnalysisListenerException {
        this.run(new DelegateOperation(){

            @Override
            public void run(AnalysisListener reportWriter) throws AnalysisListenerException {
                reportWriter.setResult(result);
            }
        });
    }

    private void run(DelegateOperation operation) throws AnalysisListenerException {
        for (AnalysisListener reportWriter : this.reportWriters) {
            operation.run(reportWriter);
        }
    }

    private static interface DelegateOperation {
        public void run(AnalysisListener var1) throws AnalysisListenerException;
    }
}

