/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.core.report.api;

import com.buschmais.jqassistant.core.analysis.api.Console;
import com.buschmais.jqassistant.core.analysis.api.Result;
import com.buschmais.jqassistant.core.analysis.api.rule.Concept;
import com.buschmais.jqassistant.core.analysis.api.rule.Constraint;
import com.buschmais.jqassistant.core.analysis.api.rule.Severity;
import com.buschmais.jqassistant.core.report.api.LanguageElement;
import com.buschmais.jqassistant.core.report.api.LanguageHelper;
import com.buschmais.jqassistant.core.report.api.SourceProvider;
import com.buschmais.jqassistant.core.report.impl.InMemoryReportWriter;
import com.buschmais.jqassistant.core.store.api.model.Descriptor;
import java.util.Collection;
import java.util.Map;

public final class ReportHelper {
    private Console console;

    public ReportHelper(Console console) {
        this.console = console;
    }

    public int verifyConceptResults(Severity violationSeverity, InMemoryReportWriter inMemoryReportWriter) {
        Collection<Result<Concept>> conceptResults = inMemoryReportWriter.getConceptResults().values();
        int violations = 0;
        for (Result<Concept> conceptResult : conceptResults) {
            if (!Result.Status.FAILURE.equals((Object)conceptResult.getStatus())) continue;
            Concept concept = (Concept)conceptResult.getRule();
            this.console.error("Concept '" + concept.getId() + "' could not be applied: " + concept.getDescription());
            if (conceptResult.getSeverity().getLevel() > violationSeverity.getLevel()) continue;
            ++violations;
        }
        return violations;
    }

    public int verifyConstraintResults(Severity violationSeverity, InMemoryReportWriter inMemoryReportWriter) {
        Collection<Result<Constraint>> constraintResults = inMemoryReportWriter.getConstraintResults().values();
        int violations = 0;
        for (Result<Constraint> constraintResult : constraintResults) {
            if (!Result.Status.FAILURE.equals((Object)constraintResult.getStatus())) continue;
            Constraint constraint = (Constraint)constraintResult.getRule();
            this.console.error("Constraint '" + constraint.getId() + "' validation failed: " + constraint.getDescription());
            for (Map columns : constraintResult.getRows()) {
                StringBuilder message = new StringBuilder();
                for (Map.Entry entry : columns.entrySet()) {
                    if (message.length() > 0) {
                        message.append(", ");
                    }
                    message.append((String)entry.getKey());
                    message.append('=');
                    String stringValue = ReportHelper.getStringValue(entry.getValue());
                    message.append(stringValue);
                }
                this.console.error("  " + message.toString());
            }
            if (constraintResult.getSeverity().getLevel() > violationSeverity.getLevel()) continue;
            ++violations;
        }
        return violations;
    }

    public static String getStringValue(Object value) {
        if (value != null) {
            if (value instanceof Descriptor) {
                Descriptor descriptor = (Descriptor)value;
                LanguageElement elementValue = LanguageHelper.getLanguageElement(descriptor);
                if (elementValue != null) {
                    SourceProvider<? extends Descriptor> sourceProvider = elementValue.getSourceProvider();
                    return sourceProvider.getName((Descriptor)descriptor);
                }
            } else {
                if (value instanceof Iterable) {
                    StringBuffer sb = new StringBuffer();
                    for (Object o : (Iterable)value) {
                        if (sb.length() > 0) {
                            sb.append(",");
                        }
                        sb.append(ReportHelper.getStringValue(o));
                    }
                    return "[" + sb.toString() + "]";
                }
                if (value instanceof Map) {
                    StringBuffer sb = new StringBuffer();
                    for (Map.Entry entry : ((Map)value).entrySet()) {
                        if (sb.length() > 0) {
                            sb.append(",");
                        }
                        sb.append((String)entry.getKey());
                        sb.append(":");
                        sb.append(ReportHelper.getStringValue(entry.getValue()));
                    }
                    return "{" + sb.toString() + "}";
                }
            }
            return value.toString();
        }
        return null;
    }
}

