/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.xo.impl.validation;

import com.buschmais.xo.impl.cache.TransactionalCache;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class InstanceValidationService {
    private final ValidatorFactory validatorFactory;
    private final TransactionalCache<?>[] caches;

    public InstanceValidationService(ValidatorFactory validatorFactory, TransactionalCache<?> ... caches) {
        this.validatorFactory = validatorFactory;
        this.caches = caches;
    }

    public Set<ConstraintViolation<Object>> validate() {
        Validator validator = this.getValidator();
        if (validator == null) {
            return Collections.emptySet();
        }
        HashSet<ConstraintViolation<Object>> violations = new HashSet<ConstraintViolation<Object>>();
        for (TransactionalCache<?> cache : this.caches) {
            for (Object instance : new ArrayList(cache.writtenInstances())) {
                violations.addAll(validator.validate(instance, new Class[0]));
            }
        }
        return violations;
    }

    public Set<ConstraintViolation<Object>> validate(Object instance) {
        Validator validator = this.getValidator();
        return validator != null ? validator.validate(instance, new Class[0]) : Collections.emptySet();
    }

    private Validator getValidator() {
        return this.validatorFactory != null ? this.validatorFactory.getValidator() : null;
    }
}

