/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.xo.impl.transaction;

import com.buschmais.xo.api.ResultIterator;
import com.buschmais.xo.api.XOTransaction;
import java.util.ArrayList;
import java.util.Iterator;

public class TransactionalResultIterator<E>
implements ResultIterator<E>,
XOTransaction.Synchronization {
    private ResultIterator<E> delegateIterator;
    private XOTransaction xoTransaction;

    public TransactionalResultIterator(ResultIterator<E> delegateIterator, XOTransaction xoTransaction) {
        this.xoTransaction = xoTransaction;
        this.delegateIterator = delegateIterator;
        if (xoTransaction != null) {
            xoTransaction.registerSynchronization((XOTransaction.Synchronization)this);
        }
    }

    public void close() {
        this.unregisterSynchronization();
        this.delegateIterator.close();
    }

    public boolean hasNext() {
        boolean hasNext = this.delegateIterator.hasNext();
        if (!hasNext) {
            this.unregisterSynchronization();
        }
        return hasNext;
    }

    public E next() {
        return (E)this.delegateIterator.next();
    }

    public void remove() {
        this.delegateIterator.remove();
    }

    public void beforeCompletion() {
        ArrayList<Object> detachedList = new ArrayList<Object>();
        while (this.delegateIterator.hasNext()) {
            detachedList.add(this.delegateIterator.next());
        }
        final Iterator iterator = detachedList.iterator();
        this.delegateIterator = new ResultIterator<E>(){

            public void close() {
            }

            public boolean hasNext() {
                return iterator.hasNext();
            }

            public E next() {
                return iterator.next();
            }

            public void remove() {
                throw new UnsupportedOperationException("Remove is not supported for this iterator.");
            }
        };
    }

    public void afterCompletion(boolean committed) {
    }

    private void unregisterSynchronization() {
        if (this.xoTransaction != null) {
            this.xoTransaction.unregisterSynchronization((XOTransaction.Synchronization)this);
            this.xoTransaction = null;
        }
    }
}

