/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.utility;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import schemacrawler.schema.Column;
import schemacrawler.schema.ForeignKey;
import schemacrawler.schema.ForeignKeyColumnReference;
import schemacrawler.schema.Index;
import schemacrawler.schema.IndexColumn;
import schemacrawler.schema.PrimaryKey;
import schemacrawler.schema.Table;

public final class MetaDataUtility {
    public static Collection<List<String>> allIndexCoumnNames(Table table) {
        return MetaDataUtility.indexCoumnNames(table, false);
    }

    public static final List<String> columnNames(Index index) {
        if (index == null) {
            return Collections.emptyList();
        }
        ArrayList<String> columnNames = new ArrayList<String>();
        for (IndexColumn indexColumn : index.getColumns()) {
            columnNames.add(indexColumn.getFullName());
        }
        return columnNames;
    }

    public static final List<String> foreignKeyColumnNames(ForeignKey foreignKey) {
        if (foreignKey == null) {
            return Collections.emptyList();
        }
        ArrayList<String> columnNames = new ArrayList<String>();
        for (ForeignKeyColumnReference columnReference : foreignKey.getColumnReferences()) {
            columnNames.add(columnReference.getForeignKeyColumn().getFullName());
        }
        return columnNames;
    }

    public static Connectivity getConnectivity(Column fkColumn, boolean isForeignKeyUnique) {
        boolean isColumnReference;
        if (fkColumn == null) {
            return Connectivity.unknown;
        }
        try {
            fkColumn.getColumnDataType();
            isColumnReference = false;
        }
        catch (Exception e) {
            isColumnReference = true;
        }
        Connectivity connectivity = isColumnReference ? Connectivity.unknown : (isForeignKeyUnique ? Connectivity.zero_one : Connectivity.zero_many);
        return connectivity;
    }

    public static boolean isForeignKeyUnique(ForeignKey foreignKey, Table table) {
        Collection<List<String>> uniqueIndexCoumnNames = MetaDataUtility.uniqueIndexCoumnNames(table);
        List<String> foreignKeyColumnNames = MetaDataUtility.foreignKeyColumnNames(foreignKey);
        return uniqueIndexCoumnNames.contains(foreignKeyColumnNames);
    }

    public static Collection<List<String>> uniqueIndexCoumnNames(Table table) {
        return MetaDataUtility.indexCoumnNames(table, true);
    }

    private static Collection<List<String>> indexCoumnNames(Table table, boolean includeUniqueOnly) {
        ArrayList<List<String>> allIndexCoumns = new ArrayList<List<String>>();
        PrimaryKey primaryKey = table.getPrimaryKey();
        List<String> pkColumns = MetaDataUtility.columnNames(primaryKey);
        allIndexCoumns.add(pkColumns);
        for (Index index : table.getIndices()) {
            if (includeUniqueOnly && !index.isUnique()) continue;
            List<String> indexColumns = MetaDataUtility.columnNames(index);
            allIndexCoumns.add(indexColumns);
        }
        return allIndexCoumns;
    }

    private MetaDataUtility() {
    }

    public static enum Connectivity {
        unknown,
        zero_one,
        zero_many,
        one_one;

    }
}

