/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.traversal;

import java.util.Collection;
import schemacrawler.schema.Catalog;
import schemacrawler.schema.ColumnDataType;
import schemacrawler.schema.Routine;
import schemacrawler.schema.Sequence;
import schemacrawler.schema.Synonym;
import schemacrawler.schema.Table;
import schemacrawler.schemacrawler.SchemaCrawlerException;
import schemacrawler.tools.traversal.SchemaTraversalHandler;

public class SchemaTraverser {
    private Catalog catalog;
    private SchemaTraversalHandler handler;

    public Catalog getCatalog() {
        return this.catalog;
    }

    public SchemaTraversalHandler getHandler() {
        return this.handler;
    }

    public void setCatalog(Catalog catalog) {
        if (catalog == null) {
            throw new IllegalArgumentException("No catalog provided");
        }
        this.catalog = catalog;
    }

    public void setHandler(SchemaTraversalHandler handler) {
        if (handler == null) {
            throw new IllegalArgumentException("No handler provided");
        }
        this.handler = handler;
    }

    public final void traverse() throws SchemaCrawlerException {
        if (this.catalog == null || this.handler == null) {
            throw new SchemaCrawlerException("Cannot traverse database");
        }
        this.handler.begin();
        this.handler.handleInfoStart();
        this.handler.handle(this.catalog.getSchemaCrawlerInfo());
        this.handler.handle(this.catalog.getDatabaseInfo());
        this.handler.handle(this.catalog.getJdbcDriverInfo());
        this.handler.handleInfoEnd();
        Collection<ColumnDataType> columnDataTypes = this.catalog.getColumnDataTypes();
        Collection<Table> tables = this.catalog.getTables();
        Collection<Routine> routines = this.catalog.getRoutines();
        Collection<Synonym> synonyms = this.catalog.getSynonyms();
        Collection<Sequence> sequences = this.catalog.getSequences();
        if (!columnDataTypes.isEmpty()) {
            this.handler.handleColumnDataTypesStart();
            for (ColumnDataType columnDataType : columnDataTypes) {
                this.handler.handle(columnDataType);
            }
            this.handler.handleColumnDataTypesEnd();
        }
        if (!tables.isEmpty()) {
            this.handler.handleTablesStart();
            for (Table table : tables) {
                this.handler.handle(table);
            }
            this.handler.handleTablesEnd();
        }
        if (!routines.isEmpty()) {
            this.handler.handleRoutinesStart();
            for (Routine routine : routines) {
                this.handler.handle(routine);
            }
            this.handler.handleRoutinesEnd();
        }
        if (!sequences.isEmpty()) {
            this.handler.handleSequencesStart();
            for (Sequence sequence : sequences) {
                this.handler.handle(sequence);
            }
            this.handler.handleSequencesEnd();
        }
        if (!synonyms.isEmpty()) {
            this.handler.handleSynonymsStart();
            for (Synonym synonym : synonyms) {
                this.handler.handle(synonym);
            }
            this.handler.handleSynonymsEnd();
        }
        this.handler.end();
    }
}

