/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.integration.graph;

import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import schemacrawler.schemacrawler.Config;
import schemacrawler.tools.text.schema.SchemaTextDetailType;
import schemacrawler.tools.text.schema.SchemaTextOptions;
import sf.util.Utility;

public class GraphOptions
extends SchemaTextOptions {
    private static final long serialVersionUID = -5850945398335496207L;
    private static final String GRAPH_SHOW_PRIMARY_KEY_CARDINALITY = "schemacrawler.graph.show.primarykey.cardinality";
    private static final String GRAPH_SHOW_FOREIGN_KEY_CARDINALITY = "schemacrawler.graph.show.foreignkey.cardinality";
    private static final String GRAPH_DETAILS = "schemacrawler.graph.details";
    private static final String GRAPH_GRAPHVIZ_OPTS = "schemacrawler.graph.graphviz_opts";
    private static final String SC_GRAPHVIZ_OPTS = "SC_GRAPHVIZ_OPTS";
    private static final Logger LOGGER = Logger.getLogger(GraphOptions.class.getName());

    public GraphOptions() {
        this(null);
    }

    public GraphOptions(Config config) {
        super(config);
        this.setShowPrimaryKeyCardinality(this.getBooleanValue(config, GRAPH_SHOW_PRIMARY_KEY_CARDINALITY, true));
        this.setShowForeignKeyCardinality(this.getBooleanValue(config, GRAPH_SHOW_FOREIGN_KEY_CARDINALITY, true));
        this.setSchemaTextDetailType(this.getEnumValue(config, GRAPH_DETAILS, SchemaTextDetailType.details));
        this.setGraphVizOpts(this.readGraphVizOpts(config));
    }

    public List<String> getGraphVizOpts() {
        String graphVizOptions = this.getStringValue(GRAPH_GRAPHVIZ_OPTS, "");
        List<String> graphVizOptionsList = Arrays.asList(graphVizOptions.split("\\s+"));
        return graphVizOptionsList;
    }

    public SchemaTextDetailType getSchemaTextDetailType() {
        return this.getEnumValue(GRAPH_DETAILS, SchemaTextDetailType.details);
    }

    public boolean isShowForeignKeyCardinality() {
        return this.getBooleanValue(GRAPH_SHOW_FOREIGN_KEY_CARDINALITY);
    }

    public boolean isShowPrimaryKeyCardinality() {
        return this.getBooleanValue(GRAPH_SHOW_PRIMARY_KEY_CARDINALITY);
    }

    public void setGraphVizOpts(String graphVizOpts) {
        if (graphVizOpts == null) {
            throw new IllegalArgumentException("Cannot use null value in a setter");
        }
        this.setStringValue(GRAPH_GRAPHVIZ_OPTS, graphVizOpts);
    }

    public void setSchemaTextDetailType(SchemaTextDetailType schemaTextDetailType) {
        if (schemaTextDetailType == null) {
            throw new IllegalArgumentException("Cannot use null value in a setter");
        }
        this.setEnumValue(GRAPH_DETAILS, schemaTextDetailType);
    }

    public void setShowForeignKeyCardinality(boolean showFkCardinality) {
        this.setBooleanValue(GRAPH_SHOW_FOREIGN_KEY_CARDINALITY, showFkCardinality);
    }

    public void setShowPrimaryKeyCardinality(boolean showPkCardinality) {
        this.setBooleanValue(GRAPH_SHOW_PRIMARY_KEY_CARDINALITY, showPkCardinality);
    }

    private String readGraphVizOpts(Config config) {
        String scGraphVizOptsCfg = this.getStringValue(config, GRAPH_GRAPHVIZ_OPTS, "");
        if (!Utility.isBlank(scGraphVizOptsCfg)) {
            LOGGER.log(Level.CONFIG, "Using additional GraphViz command-line options from config, " + scGraphVizOptsCfg);
            return scGraphVizOptsCfg;
        }
        String scGraphVizOptsProp = System.getProperty(SC_GRAPHVIZ_OPTS);
        if (!Utility.isBlank(scGraphVizOptsProp)) {
            LOGGER.log(Level.CONFIG, "Using additional GraphViz command-line options from SC_GRAPHVIZ_OPTS system property, " + scGraphVizOptsProp);
            return scGraphVizOptsProp;
        }
        String scGraphVizOptsEnv = System.getenv(SC_GRAPHVIZ_OPTS);
        if (!Utility.isBlank(scGraphVizOptsEnv)) {
            LOGGER.log(Level.CONFIG, "Using additional GraphViz command-line options from SC_GRAPHVIZ_OPTS environmental variable, " + scGraphVizOptsEnv);
            return scGraphVizOptsEnv;
        }
        return "";
    }
}

