/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.executable;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.logging.Level;
import java.util.logging.Logger;
import schemacrawler.schemacrawler.SchemaCrawlerException;
import schemacrawler.schemacrawler.SchemaCrawlerOptions;
import schemacrawler.tools.executable.CommandProvider;
import schemacrawler.tools.executable.Executable;
import schemacrawler.tools.executable.ExecutableCommandProvider;
import schemacrawler.tools.executable.SchemaExecutableCommandProvider;
import schemacrawler.tools.options.OutputOptions;

public final class CommandRegistry {
    private static final Logger LOGGER = Logger.getLogger(CommandRegistry.class.getName());
    private final Map<String, CommandProvider> commandRegistry = CommandRegistry.loadCommandRegistry();

    private static Map<String, CommandProvider> loadCommandRegistry() throws SchemaCrawlerException {
        ArrayList<ExecutableCommandProvider> commandProviders = new ArrayList<ExecutableCommandProvider>(Arrays.asList(new SchemaExecutableCommandProvider("list"), new SchemaExecutableCommandProvider("brief"), new SchemaExecutableCommandProvider("schema"), new SchemaExecutableCommandProvider("details"), new ExecutableCommandProvider("count", "schemacrawler.tools.text.operation.OperationExecutable"), new ExecutableCommandProvider("dump", "schemacrawler.tools.text.operation.OperationExecutable"), new ExecutableCommandProvider("script", "schemacrawler.tools.integration.scripting.ScriptExecutable"), new ExecutableCommandProvider("graph", "schemacrawler.tools.integration.graph.GraphExecutable")));
        try {
            ServiceLoader<CommandProvider> serviceLoader = ServiceLoader.load(CommandProvider.class);
            for (CommandProvider commandProvider : serviceLoader) {
                String executableCommand = commandProvider.getCommand();
                LOGGER.log(Level.FINER, "Loading executable, " + executableCommand + "=" + commandProvider.getClass().getName());
                commandProviders.add((ExecutableCommandProvider)commandProvider);
            }
        }
        catch (Exception e) {
            throw new SchemaCrawlerException("Could not load extended command registry", e);
        }
        HashMap<String, CommandProvider> commandRegistry = new HashMap<String, CommandProvider>();
        for (CommandProvider commandProvider : commandProviders) {
            commandRegistry.put(commandProvider.getCommand(), commandProvider);
        }
        return commandRegistry;
    }

    public String getHelpResource(String command) {
        String helpResource = this.commandRegistry.containsKey(command) ? this.commandRegistry.get(command).getHelpResource() : null;
        return helpResource;
    }

    public boolean hasCommand(String command) {
        return this.commandRegistry.containsKey(command);
    }

    public Collection<String> lookupAvailableCommands() {
        ArrayList<String> availableCommands = new ArrayList<String>(this.commandRegistry.keySet());
        Collections.sort(availableCommands);
        return availableCommands;
    }

    Executable configureNewExecutable(String command, SchemaCrawlerOptions schemaCrawlerOptions, OutputOptions outputOptions) throws SchemaCrawlerException {
        CommandProvider commandProvider = this.commandRegistry.containsKey(command) ? this.commandRegistry.get(command) : new ExecutableCommandProvider(command, "schemacrawler.tools.text.operation.OperationExecutable");
        return commandProvider.configureNewExecutable(schemaCrawlerOptions, outputOptions);
    }
}

