/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.analysis.associations;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

public class Inflection {
    private static final List<Inflection> plural = new ArrayList<Inflection>();
    private static final List<Inflection> singular = new ArrayList<Inflection>();
    private static final List<String> uncountable = new ArrayList<String>();
    private final String pattern;
    private final String replacement;
    private final boolean ignoreCase;

    public static boolean isUncountable(String word) {
        for (String w : uncountable) {
            if (!w.equalsIgnoreCase(word)) continue;
            return true;
        }
        return false;
    }

    public static String pluralize(String word) {
        if (Inflection.isUncountable(word)) {
            return word;
        }
        for (Inflection inflection : plural) {
            if (!inflection.match(word)) continue;
            return inflection.replace(word);
        }
        return word;
    }

    public static String singularize(String word) {
        if (Inflection.isUncountable(word)) {
            return word;
        }
        for (Inflection inflection : singular) {
            if (!inflection.match(word)) continue;
            return inflection.replace(word);
        }
        return word;
    }

    private static void irregular(String s, String p) {
        Inflection.plural("(" + s.substring(0, 1) + ")" + s.substring(1) + "$", "$1" + p.substring(1));
        Inflection.singular("(" + p.substring(0, 1) + ")" + p.substring(1) + "$", "$1" + s.substring(1));
    }

    private static void plural(String pattern, String replacement) {
        plural.add(0, new Inflection(pattern, replacement));
    }

    private static void singular(String pattern, String replacement) {
        singular.add(0, new Inflection(pattern, replacement));
    }

    private static void uncountable(String word) {
        uncountable.add(word);
    }

    public Inflection(String pattern) {
        this(pattern, null, true);
    }

    public Inflection(String pattern, String replacement) {
        this(pattern, replacement, true);
    }

    public Inflection(String pattern, String replacement, boolean ignoreCase) {
        this.pattern = pattern;
        this.replacement = replacement;
        this.ignoreCase = ignoreCase;
    }

    public boolean match(String word) {
        int flags = 0;
        if (this.ignoreCase) {
            flags |= 2;
        }
        return Pattern.compile(this.pattern, flags).matcher(word).find();
    }

    public String replace(String word) {
        int flags = 0;
        if (this.ignoreCase) {
            flags |= 2;
        }
        return Pattern.compile(this.pattern, flags).matcher(word).replaceAll(this.replacement);
    }

    static {
        Inflection.plural("$", "s");
        Inflection.plural("s$", "s");
        Inflection.plural("(ax|test)is$", "$1es");
        Inflection.plural("(octop|vir)us$", "$1i");
        Inflection.plural("(alias|status)$", "$1es");
        Inflection.plural("(bu)s$", "$1ses");
        Inflection.plural("(buffal|tomat)o$", "$1oes");
        Inflection.plural("([ti])um$", "$1a");
        Inflection.plural("sis$", "ses");
        Inflection.plural("(?:([^f])fe|([lr])f)$", "$1$2ves");
        Inflection.plural("(hive)$", "$1s");
        Inflection.plural("([^aeiouy]|qu)y$", "$1ies");
        Inflection.plural("(x|ch|ss|sh)$", "$1es");
        Inflection.plural("(matr|vert|ind)ix|ex$", "$1ices");
        Inflection.plural("([m|l])ouse$", "$1ice");
        Inflection.plural("^(ox)$", "$1en");
        Inflection.plural("(quiz)$", "$1zes");
        Inflection.singular("s$", "");
        Inflection.singular("(n)ews$", "$1ews");
        Inflection.singular("([ti])a$", "$1um");
        Inflection.singular("((a)naly|(b)a|(d)iagno|(p)arenthe|(p)rogno|(s)ynop|(t)he)ses$", "$1$2sis");
        Inflection.singular("(^analy)ses$", "$1sis");
        Inflection.singular("([^f])ves$", "$1fe");
        Inflection.singular("(hive)s$", "$1");
        Inflection.singular("(tive)s$", "$1");
        Inflection.singular("([lr])ves$", "$1f");
        Inflection.singular("([^aeiouy]|qu)ies$", "$1y");
        Inflection.singular("(s)eries$", "$1eries");
        Inflection.singular("(m)ovies$", "$1ovie");
        Inflection.singular("(x|ch|ss|sh)es$", "$1");
        Inflection.singular("([m|l])ice$", "$1ouse");
        Inflection.singular("(bus)es$", "$1");
        Inflection.singular("(o)es$", "$1");
        Inflection.singular("(shoe)s$", "$1");
        Inflection.singular("(cris|ax|test)es$", "$1is");
        Inflection.singular("(octop|vir)i$", "$1us");
        Inflection.singular("(alias|status)es$", "$1");
        Inflection.singular("^(ox)en", "$1");
        Inflection.singular("(vert|ind)ices$", "$1ex");
        Inflection.singular("(matr)ices$", "$1ix");
        Inflection.singular("(quiz)zes$", "$1");
        Inflection.irregular("person", "people");
        Inflection.irregular("man", "men");
        Inflection.irregular("child", "children");
        Inflection.irregular("sex", "sexes");
        Inflection.irregular("move", "moves");
        Inflection.irregular("sleeve", "sleeves");
        Inflection.uncountable("equipment");
        Inflection.uncountable("information");
        Inflection.uncountable("rice");
        Inflection.uncountable("money");
        Inflection.uncountable("species");
        Inflection.uncountable("series");
        Inflection.uncountable("fish");
        Inflection.uncountable("sheep");
    }
}

