/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.plugin.maven3.impl.scanner;

import com.buschmais.jqassistant.core.scanner.api.Scanner;
import com.buschmais.jqassistant.core.scanner.api.Scope;
import com.buschmais.jqassistant.plugin.common.api.model.FileDescriptor;
import com.buschmais.jqassistant.plugin.common.api.scanner.AbstractScannerPlugin;
import com.buschmais.jqassistant.plugin.common.api.scanner.filesystem.FileResource;
import com.buschmais.jqassistant.plugin.maven3.api.model.MavenPomXmlDescriptor;
import com.buschmais.jqassistant.plugin.maven3.api.scanner.PomModelBuilder;
import com.buschmais.jqassistant.plugin.xml.api.model.XmlFileDescriptor;
import com.buschmais.jqassistant.plugin.xml.api.scanner.XmlScope;
import java.io.IOException;
import java.io.InputStream;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public abstract class AbstractMavenPomScannerPlugin
extends AbstractScannerPlugin<FileResource, MavenPomXmlDescriptor> {
    private MavenXpp3Reader mavenXpp3Reader;

    public void initialize() {
        this.mavenXpp3Reader = new MavenXpp3Reader();
    }

    public Class<? extends FileResource> getType() {
        return FileResource.class;
    }

    public Class<? extends MavenPomXmlDescriptor> getDescriptorType() {
        return MavenPomXmlDescriptor.class;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MavenPomXmlDescriptor scan(FileResource item, String path, Scope scope, Scanner scanner) throws IOException {
        Model model;
        XmlFileDescriptor xmlFileDescriptor = (XmlFileDescriptor)scanner.scan((Object)item, path, (Scope)XmlScope.DOCUMENT);
        PomModelBuilder pomModelBuilder = (PomModelBuilder)scanner.getContext().peek(PomModelBuilder.class);
        if (pomModelBuilder != null) {
            model = pomModelBuilder.getModel(item.getFile());
        } else {
            try (InputStream stream = item.createStream();){
                model = this.mavenXpp3Reader.read(stream);
            }
            catch (XmlPullParserException e) {
                throw new IOException("Cannot read POM descriptor.", e);
            }
        }
        scanner.getContext().push(FileDescriptor.class, (Object)xmlFileDescriptor);
        try {
            MavenPomXmlDescriptor mavenPomXmlDescriptor = (MavenPomXmlDescriptor)scanner.scan((Object)model, path, scope);
            return mavenPomXmlDescriptor;
        }
        finally {
            scanner.getContext().pop(FileDescriptor.class);
        }
    }
}

