/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.pagecache.impl.muninn;

import java.io.IOException;
import java.util.concurrent.locks.LockSupport;
import org.neo4j.io.pagecache.impl.muninn.MuninnPage;
import org.neo4j.io.pagecache.impl.muninn.MuninnPageCache;

final class FreePageWaiter {
    private static final MuninnPage interruptSignal = new MuninnPage(0, null);
    private static final MuninnPage exceptionSignal = new MuninnPage(0, null);
    FreePageWaiter next;
    private final Thread waiter = Thread.currentThread();
    private IOException exception;
    private volatile MuninnPage page;

    public MuninnPage park(MuninnPageCache muninnPageCache) throws IOException {
        MuninnPage page;
        do {
            LockSupport.park(muninnPageCache);
        } while ((page = this.page) == null);
        if (page == exceptionSignal) {
            throw new IOException("Exception in the page eviction thread", this.exception);
        }
        return page == interruptSignal ? null : page;
    }

    public void unpark(MuninnPage page) {
        this.page = page;
        LockSupport.unpark(this.waiter);
    }

    public void unparkInterrupt() {
        this.page = interruptSignal;
        LockSupport.unpark(this.waiter);
    }

    public void unparkException(IOException exception) {
        this.exception = exception;
        this.page = exceptionSignal;
        LockSupport.unpark(this.waiter);
    }

    public String toString() {
        return this.shortString() + " -> " + (this.next == null ? "null" : this.next.shortString());
    }

    private String shortString() {
        return "FreePageWaiter@" + Integer.toHexString(this.hashCode()) + "[t:" + this.waiter.getId() + "]";
    }
}

