/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.pagecache.impl.muninn;

import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;

final class BackgroundThreadExecutor
implements Executor {
    static final BackgroundThreadExecutor INSTANCE = new BackgroundThreadExecutor();
    private final Executor executor = Executors.newCachedThreadPool(new DaemonThreadFactory());

    private BackgroundThreadExecutor() {
    }

    @Override
    public void execute(Runnable command) {
        this.executor.execute(command);
    }

    private static final class DaemonThreadFactory
    implements ThreadFactory {
        private DaemonThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable r) {
            ThreadFactory def = Executors.defaultThreadFactory();
            Thread thread = def.newThread(r);
            thread.setDaemon(true);
            return thread;
        }
    }
}

