/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.core.analysis.impl;

import com.buschmais.jqassistant.core.analysis.api.RuleException;
import com.buschmais.jqassistant.core.analysis.api.RuleSetReader;
import com.buschmais.jqassistant.core.analysis.api.rule.AggregationVerification;
import com.buschmais.jqassistant.core.analysis.api.rule.Concept;
import com.buschmais.jqassistant.core.analysis.api.rule.Constraint;
import com.buschmais.jqassistant.core.analysis.api.rule.CypherExecutable;
import com.buschmais.jqassistant.core.analysis.api.rule.Executable;
import com.buschmais.jqassistant.core.analysis.api.rule.Group;
import com.buschmais.jqassistant.core.analysis.api.rule.Metric;
import com.buschmais.jqassistant.core.analysis.api.rule.MetricGroup;
import com.buschmais.jqassistant.core.analysis.api.rule.Report;
import com.buschmais.jqassistant.core.analysis.api.rule.RowCountVerification;
import com.buschmais.jqassistant.core.analysis.api.rule.RuleSetBuilder;
import com.buschmais.jqassistant.core.analysis.api.rule.ScriptExecutable;
import com.buschmais.jqassistant.core.analysis.api.rule.Severity;
import com.buschmais.jqassistant.core.analysis.api.rule.Template;
import com.buschmais.jqassistant.core.analysis.api.rule.TemplateExecutable;
import com.buschmais.jqassistant.core.analysis.api.rule.Verification;
import com.buschmais.jqassistant.core.analysis.api.rule.source.RuleSource;
import com.buschmais.jqassistant.core.analysis.impl.XmlHelper;
import com.buschmais.jqassistant.core.analysis.rules.schema.v1.AggregationVerificationType;
import com.buschmais.jqassistant.core.analysis.rules.schema.v1.ConceptType;
import com.buschmais.jqassistant.core.analysis.rules.schema.v1.ConstraintType;
import com.buschmais.jqassistant.core.analysis.rules.schema.v1.ExecutableRuleType;
import com.buschmais.jqassistant.core.analysis.rules.schema.v1.GroupType;
import com.buschmais.jqassistant.core.analysis.rules.schema.v1.IncludedReferenceType;
import com.buschmais.jqassistant.core.analysis.rules.schema.v1.JqassistantRules;
import com.buschmais.jqassistant.core.analysis.rules.schema.v1.MetricGroupType;
import com.buschmais.jqassistant.core.analysis.rules.schema.v1.MetricType;
import com.buschmais.jqassistant.core.analysis.rules.schema.v1.ObjectFactory;
import com.buschmais.jqassistant.core.analysis.rules.schema.v1.ParameterDefinitionType;
import com.buschmais.jqassistant.core.analysis.rules.schema.v1.ParameterType;
import com.buschmais.jqassistant.core.analysis.rules.schema.v1.ParameterTypes;
import com.buschmais.jqassistant.core.analysis.rules.schema.v1.ReferenceType;
import com.buschmais.jqassistant.core.analysis.rules.schema.v1.ReferenceableType;
import com.buschmais.jqassistant.core.analysis.rules.schema.v1.ReportType;
import com.buschmais.jqassistant.core.analysis.rules.schema.v1.RowCountVerificationType;
import com.buschmais.jqassistant.core.analysis.rules.schema.v1.ScriptType;
import com.buschmais.jqassistant.core.analysis.rules.schema.v1.SeverityEnumType;
import com.buschmais.jqassistant.core.analysis.rules.schema.v1.TemplateType;
import com.buschmais.jqassistant.core.analysis.rules.schema.v1.VerificationType;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XmlRuleSetReader
implements RuleSetReader {
    public static final String RULES_SCHEMA_LOCATION = "/META-INF/xsd/jqassistant-rules-1.0.xsd";
    public static final Schema SCHEMA = XmlHelper.getSchema("/META-INF/xsd/jqassistant-rules-1.0.xsd");
    private static final Logger LOGGER = LoggerFactory.getLogger(XmlRuleSetReader.class);
    private static final JAXBContext JAXB_CONTEXT;
    public static final RowCountVerification DEFAULT_VERIFICATION;

    @Override
    public void read(List<? extends RuleSource> sources, RuleSetBuilder ruleSetBuilder) throws RuleException {
        for (RuleSource ruleSource : sources) {
            if (!ruleSource.isType(RuleSource.Type.XML)) continue;
            List<JqassistantRules> rules = this.readXmlSource(ruleSource);
            this.convert(rules, ruleSource, ruleSetBuilder);
        }
    }

    private List<JqassistantRules> readXmlSource(RuleSource ruleSource) {
        ArrayList<JqassistantRules> rules = new ArrayList<JqassistantRules>();
        try (InputStream inputStream = ruleSource.getInputStream();){
            Unmarshaller unmarshaller = JAXB_CONTEXT.createUnmarshaller();
            unmarshaller.setSchema(SCHEMA);
            LOGGER.debug("Reading rules from '{}'.", (Object)ruleSource.getId());
            StreamSource streamSource = new StreamSource(inputStream);
            JAXBElement jaxbElement = unmarshaller.unmarshal((Source)streamSource, JqassistantRules.class);
            rules.add((JqassistantRules)jaxbElement.getValue());
        }
        catch (IOException | JAXBException e) {
            throw new IllegalArgumentException("Cannot read rules from '" + ruleSource.getId() + "'.", e);
        }
        return rules;
    }

    private void convert(List<JqassistantRules> rules, RuleSource ruleSource, RuleSetBuilder builder) throws RuleException {
        for (JqassistantRules rule : rules) {
            List<ReferenceableType> queryDefinitionOrConceptOrConstraint = rule.getTemplateOrConceptOrConstraint();
            for (ReferenceableType referenceableType : queryDefinitionOrConceptOrConstraint) {
                String id = referenceableType.getId();
                if (referenceableType instanceof TemplateType) {
                    Template template = this.createTemplate((TemplateType)referenceableType, ruleSource);
                    builder.addTemplate(template);
                    continue;
                }
                if (referenceableType instanceof ConceptType) {
                    Concept concept = this.createConcept(id, ruleSource, (ConceptType)referenceableType);
                    builder.addConcept(concept);
                    continue;
                }
                if (referenceableType instanceof ConstraintType) {
                    Constraint constraint = this.createConstraint(id, ruleSource, (ConstraintType)referenceableType);
                    builder.addConstraint(constraint);
                    continue;
                }
                if (referenceableType instanceof GroupType) {
                    Group group = this.createGroup(id, ruleSource, (GroupType)referenceableType);
                    builder.addGroup(group);
                    continue;
                }
                if (!(referenceableType instanceof MetricGroupType)) continue;
                MetricGroup metricGroup = this.createMetricGroup(id, ruleSource, (MetricGroupType)referenceableType);
                builder.addMetricGroup(metricGroup);
            }
        }
    }

    private Template createTemplate(TemplateType templateType, RuleSource ruleSource) throws RuleException {
        HashMap parameterTypes = new HashMap();
        for (ParameterDefinitionType parameterDefinitionType : templateType.getParameterDefinition()) {
            Class parameterType;
            switch (parameterDefinitionType.getType()) {
                case INT: {
                    parameterType = Integer.class;
                    break;
                }
                case STRING: {
                    parameterType = String.class;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported parameter parameterDefinitionType " + (Object)((Object)parameterDefinitionType.getType()));
                }
            }
            parameterTypes.put(parameterDefinitionType.getName(), parameterType);
        }
        Executable executable = this.createExecutable(templateType);
        return new Template(templateType.getId(), templateType.getDescription(), ruleSource, executable, parameterTypes);
    }

    private MetricGroup createMetricGroup(String id, RuleSource ruleSource, MetricGroupType referenceableType) {
        MetricGroupType metricGroupType = referenceableType;
        LinkedHashMap<String, Metric> metrics = new LinkedHashMap<String, Metric>();
        for (MetricType metricType : metricGroupType.getMetric()) {
            String cypher = metricType.getCypher();
            String description = metricType.getDescription();
            Map<String, Class<?>> parameterTypes = this.getParameterTypes(metricType.getParameterDefinition());
            Set<String> requiresConcepts = this.getReferences(metricType.getRequiresConcept());
            Metric metric = new Metric(metricType.getId(), description, ruleSource, new CypherExecutable(cypher), parameterTypes, requiresConcepts);
            metrics.put(metricType.getId(), metric);
        }
        return new MetricGroup(id, metricGroupType.getDescription(), ruleSource, metrics);
    }

    private Group createGroup(String id, RuleSource ruleSource, GroupType referenceableType) {
        GroupType groupType = referenceableType;
        Map<String, Severity> includeConcepts = this.getReferences(groupType.getIncludeConcept(), Concept.DEFAULT_SEVERITY);
        Map<String, Severity> includeConstraints = this.getReferences(groupType.getIncludeConstraint(), Constraint.DEFAULT_SEVERITY);
        Set<String> includeGroups = this.getReferences(groupType.getIncludeGroup());
        return new Group(id, null, ruleSource, includeConcepts, includeConstraints, includeGroups);
    }

    private Concept createConcept(String id, RuleSource ruleSource, ConceptType referenceableType) throws RuleException {
        ConceptType conceptType = referenceableType;
        String description = conceptType.getDescription();
        Executable executable = this.createExecutable(referenceableType);
        Map<String, Object> parameters = this.getParameterValues(conceptType.getParameter());
        SeverityEnumType severityType = conceptType.getSeverity();
        Severity severity = this.getSeverity(severityType, Concept.DEFAULT_SEVERITY);
        List<ReferenceType> requiresConcept = conceptType.getRequiresConcept();
        Set<String> requiresConcepts = this.getReferences(requiresConcept);
        String deprecated = conceptType.getDeprecated();
        Verification verification = this.getVerification(conceptType.getVerify());
        Report report = this.getReport(conceptType.getReport());
        return new Concept(id, description, ruleSource, severity, deprecated, executable, parameters, requiresConcepts, verification, report);
    }

    private Report getReport(ReportType reportType) {
        String primaryColumn = null;
        if (reportType != null) {
            primaryColumn = reportType.getPrimaryColumn();
        }
        return new Report(primaryColumn);
    }

    private Constraint createConstraint(String id, RuleSource ruleSource, ConstraintType referenceableType) throws RuleException {
        ConstraintType constraintType = referenceableType;
        Executable executable = this.createExecutable(constraintType);
        String description = constraintType.getDescription();
        Map<String, Object> parameters = this.getParameterValues(constraintType.getParameter());
        SeverityEnumType severityType = constraintType.getSeverity();
        Severity severity = this.getSeverity(severityType, Constraint.DEFAULT_SEVERITY);
        List<ReferenceType> requiresConcept = constraintType.getRequiresConcept();
        Set<String> requiresConcepts = this.getReferences(requiresConcept);
        String deprecated = constraintType.getDeprecated();
        Verification verification = this.getVerification(constraintType.getVerify());
        Report report = this.getReport(constraintType.getReport());
        return new Constraint(id, description, ruleSource, severity, deprecated, executable, parameters, requiresConcepts, verification, report);
    }

    private Executable createExecutable(ExecutableRuleType executableRuleType) throws RuleException {
        String cypher = executableRuleType.getCypher();
        ScriptType scriptType = executableRuleType.getScript();
        ReferenceType useTemplate = executableRuleType.getUseTemplate();
        if (cypher != null) {
            return new CypherExecutable(cypher);
        }
        if (scriptType != null) {
            return new ScriptExecutable(scriptType.getLanguage(), scriptType.getValue());
        }
        if (useTemplate != null) {
            return new TemplateExecutable(useTemplate.getRefId());
        }
        throw new RuleException("Cannot determine executable for " + executableRuleType.getId());
    }

    private Verification getVerification(VerificationType verificationType) throws RuleException {
        if (verificationType != null) {
            RowCountVerificationType rowCountVerificationType = verificationType.getRowCount();
            AggregationVerificationType aggregationVerificationType = verificationType.getAggregation();
            if (rowCountVerificationType != null) {
                return new RowCountVerification();
            }
            if (aggregationVerificationType != null) {
                String column = aggregationVerificationType.getColumn();
                return new AggregationVerification(column);
            }
            throw new RuleException("Unsupported verification " + verificationType);
        }
        return DEFAULT_VERIFICATION;
    }

    private Set<String> getReferences(List<? extends ReferenceType> referenceTypes) {
        HashSet<String> references = new HashSet<String>();
        for (ReferenceType referenceType : referenceTypes) {
            references.add(referenceType.getRefId());
        }
        return references;
    }

    private Map<String, Severity> getReferences(List<IncludedReferenceType> referenceType, Severity defaultConceptSeverity) {
        HashMap<String, Severity> references = new HashMap<String, Severity>();
        for (IncludedReferenceType includedRefereceType : referenceType) {
            Severity severity = this.getSeverity(includedRefereceType.getSeverity(), defaultConceptSeverity);
            references.put(includedRefereceType.getRefId(), severity);
        }
        return references;
    }

    private Map<String, Class<?>> getParameterTypes(List<ParameterDefinitionType> parameterDefinitionTypes) {
        HashMap parameters = new HashMap();
        for (ParameterDefinitionType parameterDefinitionType : parameterDefinitionTypes) {
            Class type;
            switch (parameterDefinitionType.getType()) {
                case INT: {
                    type = Integer.class;
                    break;
                }
                case STRING: {
                    type = String.class;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported parameter definition type" + parameterDefinitionType);
                }
            }
            parameters.put(parameterDefinitionType.getName(), type);
        }
        return parameters;
    }

    private Severity getSeverity(SeverityEnumType severityType, Severity defaultSeverity) {
        return severityType == null ? defaultSeverity : Severity.fromValue(severityType.value());
    }

    private Object getParameterType(ParameterTypes type, String stringValue) {
        Object value;
        switch (type) {
            case INT: {
                value = Integer.valueOf(stringValue);
                break;
            }
            case STRING: {
                value = stringValue;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported parameter types: " + (Object)((Object)type));
            }
        }
        return value;
    }

    private Map<String, Object> getParameterValues(List<ParameterType> parameter) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        for (ParameterType parameterType : parameter) {
            Object value = this.getParameterValue(parameterType.getType(), parameterType.getValue());
            parameters.put(parameterType.getName(), value);
        }
        return parameters;
    }

    private Object getParameterValue(ParameterTypes type, String stringValue) {
        Object value;
        switch (type) {
            case INT: {
                value = Integer.valueOf(stringValue);
                break;
            }
            case STRING: {
                value = stringValue;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported parameter types: " + (Object)((Object)type));
            }
        }
        return value;
    }

    static {
        try {
            JAXB_CONTEXT = JAXBContext.newInstance((Class[])new Class[]{ObjectFactory.class});
        }
        catch (JAXBException e) {
            throw new IllegalArgumentException("Cannot create JAXB context.", e);
        }
        DEFAULT_VERIFICATION = new RowCountVerification();
    }
}

