/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.core.analysis.impl;

import com.buschmais.jqassistant.core.analysis.api.AnalysisException;
import com.buschmais.jqassistant.core.analysis.api.RuleSelection;
import com.buschmais.jqassistant.core.analysis.api.rule.Concept;
import com.buschmais.jqassistant.core.analysis.api.rule.Constraint;
import com.buschmais.jqassistant.core.analysis.api.rule.Group;
import com.buschmais.jqassistant.core.analysis.api.rule.RuleSet;
import com.buschmais.jqassistant.core.analysis.api.rule.Severity;
import com.buschmais.jqassistant.core.analysis.api.rule.Template;
import com.buschmais.jqassistant.core.analysis.impl.RuleVisitor;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class RuleExecutor {
    private Set<Concept> executedConcepts = new HashSet<Concept>();
    private Set<Constraint> executedConstraints = new HashSet<Constraint>();
    private Set<Group> executedGroups = new HashSet<Group>();
    private RuleVisitor ruleVisitor;

    public RuleExecutor(RuleVisitor ruleVisitor) {
        this.ruleVisitor = ruleVisitor;
    }

    public void execute(RuleSet ruleSet, RuleSelection ruleSelection) throws AnalysisException {
        for (String conceptId : ruleSelection.getConceptIds()) {
            Concept concept = this.resolveConcept(ruleSet, conceptId);
            this.applyConcept(ruleSet, concept, concept.getSeverity());
        }
        for (String constraintId : ruleSelection.getConstraintIds()) {
            Constraint constraint = this.resolveConstraint(ruleSet, constraintId);
            this.validateConstraint(ruleSet, constraint, constraint.getSeverity());
        }
        for (String groupId : ruleSelection.getGroupIds()) {
            this.executeGroup(ruleSet, this.resolveGroup(ruleSet, groupId));
        }
    }

    private void executeGroup(RuleSet ruleSet, Group group) throws AnalysisException {
        if (!this.executedGroups.contains(group)) {
            Severity severity;
            for (String includedGroupId : group.getGroups()) {
                Group includedGroup = this.resolveGroup(ruleSet, includedGroupId);
                this.executeGroup(ruleSet, includedGroup);
            }
            this.ruleVisitor.beforeGroup(group);
            Map<String, Severity> concepts = group.getConcepts();
            for (Map.Entry<String, Severity> conceptEntry : concepts.entrySet()) {
                String conceptId = conceptEntry.getKey();
                severity = conceptEntry.getValue();
                Concept concept = this.resolveConcept(ruleSet, conceptId);
                this.applyConcept(ruleSet, concept, severity);
            }
            for (Map.Entry<String, Severity> constraintEntry : group.getConstraints().entrySet()) {
                String constraintId = constraintEntry.getKey();
                severity = constraintEntry.getValue();
                Constraint constraint = this.resolveConstraint(ruleSet, constraintId);
                this.validateConstraint(ruleSet, constraint, severity);
            }
            this.executedGroups.add(group);
            this.ruleVisitor.afterGroup(group);
        }
    }

    private void validateConstraint(RuleSet ruleSet, Constraint constraint, Severity severity) throws AnalysisException {
        if (!this.executedConstraints.contains(constraint)) {
            for (String requiredConceptId : constraint.getRequiresConcepts()) {
                Concept requiredConcept = this.resolveConcept(ruleSet, requiredConceptId);
                this.applyConcept(ruleSet, requiredConcept, requiredConcept.getSeverity());
            }
            this.ruleVisitor.visitConstraint(constraint, severity);
            this.executedConstraints.add(constraint);
        }
    }

    private void applyConcept(RuleSet ruleSet, Concept concept, Severity severity) throws AnalysisException {
        if (!this.executedConcepts.contains(concept)) {
            for (String requiredConceptId : concept.getRequiresConcepts()) {
                Concept requiredConcept = this.resolveConcept(ruleSet, requiredConceptId);
                this.applyConcept(ruleSet, requiredConcept, requiredConcept.getSeverity());
            }
            this.ruleVisitor.visitConcept(concept, severity);
            this.executedConcepts.add(concept);
        }
    }

    public Template resolveTemplate(RuleSet ruleSet, String queryTemplateId) throws AnalysisException {
        Template template = ruleSet.getTemplates().get(queryTemplateId);
        if (template == null) {
            throw new AnalysisException("Query template '" + queryTemplateId + " is not defined.");
        }
        return template;
    }

    public Concept resolveConcept(RuleSet ruleSet, String requiredConceptId) throws AnalysisException {
        Concept requiredConcept = ruleSet.getConcepts().get(requiredConceptId);
        if (requiredConcept == null) {
            throw new AnalysisException("Concept '" + requiredConceptId + "' is not defined.");
        }
        return requiredConcept;
    }

    public Constraint resolveConstraint(RuleSet ruleSet, String constraintId) throws AnalysisException {
        Constraint constraint = ruleSet.getConstraints().get(constraintId);
        if (constraint == null) {
            throw new AnalysisException("Constraint '" + constraintId + "' not found.");
        }
        return constraint;
    }

    public Group resolveGroup(RuleSet ruleSet, String groupId) throws AnalysisException {
        Group group = ruleSet.getGroups().get(groupId);
        if (group == null) {
            throw new AnalysisException("Group '" + groupId + "' is not defined.");
        }
        return group;
    }
}

