/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.core.analysis.impl;

import com.buschmais.jqassistant.core.analysis.api.RuleException;
import com.buschmais.jqassistant.core.analysis.api.RuleSetReader;
import com.buschmais.jqassistant.core.analysis.api.rule.AbstractExecutableRule;
import com.buschmais.jqassistant.core.analysis.api.rule.AggregationVerification;
import com.buschmais.jqassistant.core.analysis.api.rule.Concept;
import com.buschmais.jqassistant.core.analysis.api.rule.Constraint;
import com.buschmais.jqassistant.core.analysis.api.rule.CypherExecutable;
import com.buschmais.jqassistant.core.analysis.api.rule.Executable;
import com.buschmais.jqassistant.core.analysis.api.rule.Report;
import com.buschmais.jqassistant.core.analysis.api.rule.RowCountVerification;
import com.buschmais.jqassistant.core.analysis.api.rule.RuleSetBuilder;
import com.buschmais.jqassistant.core.analysis.api.rule.ScriptExecutable;
import com.buschmais.jqassistant.core.analysis.api.rule.Severity;
import com.buschmais.jqassistant.core.analysis.api.rule.Verification;
import com.buschmais.jqassistant.core.analysis.api.rule.source.RuleSource;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.asciidoctor.Asciidoctor;
import org.asciidoctor.ast.ContentPart;
import org.asciidoctor.ast.StructuredDocument;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsciiDocRuleSetReader
implements RuleSetReader {
    private static final Set<String> RULETYPES = new HashSet<String>(Arrays.asList("concept", "constraint"));
    private static final Logger LOGGER = LoggerFactory.getLogger(AsciiDocRuleSetReader.class);
    private Asciidoctor cachedAsciidoctor = null;

    @Override
    public void read(List<? extends RuleSource> sources, RuleSetBuilder ruleSetBuilder) throws RuleException {
        for (RuleSource ruleSource : sources) {
            if (!ruleSource.isType(RuleSource.Type.AsciiDoc)) continue;
            this.readDocument(ruleSource, ruleSetBuilder);
        }
    }

    private void readDocument(RuleSource source, RuleSetBuilder builder) throws RuleException {
        InputStream stream;
        HashMap<String, Integer> parameters = new HashMap<String, Integer>();
        parameters.put("STRUCTURE_MAX_LEVEL", 10);
        try {
            stream = source.getInputStream();
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Cannot read rules from '" + source.getId() + "'.", e);
        }
        StructuredDocument doc = this.getAsciidoctor().readDocumentStructure((Reader)new InputStreamReader(stream), parameters);
        this.extractRules(doc, source, builder);
    }

    private Asciidoctor getAsciidoctor() {
        if (this.cachedAsciidoctor == null) {
            LOGGER.debug("Creating Asciidoctor instance.");
            this.cachedAsciidoctor = Asciidoctor.Factory.create();
        }
        return this.cachedAsciidoctor;
    }

    private void extractRules(StructuredDocument doc, RuleSource ruleSource, RuleSetBuilder builder) throws RuleException {
        for (ContentPart part : AsciiDocRuleSetReader.findListings(doc)) {
            AbstractExecutableRule concept;
            Severity severity;
            Object aggregationColumn;
            Map attributes = part.getAttributes();
            String id = part.getId();
            String description = attributes.get("title").toString();
            Set<String> requiresConcepts = this.getDependencies(attributes);
            Object language = part.getAttributes().get("language");
            String source = this.unescapeHtml(part.getContent());
            Executable executable = "cypher".equals(language) ? new CypherExecutable(source) : new ScriptExecutable(language.toString(), source);
            boolean aggregation = "aggregation".equals(part.getAttributes().get("verify"));
            Verification verification = aggregation ? new AggregationVerification((aggregationColumn = part.getAttributes().get("aggregationColumn")) != null ? aggregationColumn.toString() : null) : new RowCountVerification();
            Object primaryReportColum = part.getAttributes().get("primaryReportColum");
            Report report = new Report(primaryReportColum != null ? primaryReportColum.toString() : null);
            if ("concept".equals(part.getRole())) {
                severity = this.getSeverity(part, Concept.DEFAULT_SEVERITY);
                concept = new Concept(id, description, ruleSource, severity, null, executable, Collections.emptyMap(), requiresConcepts, verification, report);
                builder.addConcept((Concept)concept);
                continue;
            }
            if (!"constraint".equals(part.getRole())) continue;
            severity = this.getSeverity(part, Constraint.DEFAULT_SEVERITY);
            concept = new Constraint(id, description, ruleSource, severity, null, executable, Collections.emptyMap(), requiresConcepts, verification, report);
            builder.addConstraint((Constraint)concept);
        }
    }

    private Severity getSeverity(ContentPart part, Severity defaultSeverity) {
        Object severity = part.getAttributes().get("severity");
        return severity == null ? defaultSeverity : Severity.fromValue(severity.toString().toLowerCase());
    }

    private String unescapeHtml(String content) {
        return content.replace("&lt;", "<").replace("&gt;", ">");
    }

    private Set<String> getDependencies(Map<String, Object> attributes) {
        String depends = (String)attributes.get("depends");
        HashSet<String> dependencies = new HashSet<String>();
        if (depends != null && !depends.trim().isEmpty()) {
            dependencies.addAll(Arrays.asList(depends.split("\\s*,\\s*")));
        }
        return dependencies;
    }

    private static Collection<ContentPart> findListings(StructuredDocument doc) {
        LinkedHashSet<ContentPart> result = new LinkedHashSet<ContentPart>();
        result.addAll(AsciiDocRuleSetReader.findListings(doc.getParts()));
        return result;
    }

    private static Collection<ContentPart> findListings(Collection<ContentPart> parts) {
        LinkedHashSet<ContentPart> result = new LinkedHashSet<ContentPart>();
        if (parts != null) {
            for (ContentPart part : parts) {
                if ("listing".equals(part.getContext()) && "source".equals(part.getStyle()) && RULETYPES.contains(part.getRole())) {
                    result.add(part);
                }
                result.addAll(AsciiDocRuleSetReader.findListings(part.getParts()));
            }
        }
        return result;
    }
}

