/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.core.analysis.impl;

import com.buschmais.jqassistant.core.analysis.api.AnalysisException;
import com.buschmais.jqassistant.core.analysis.api.Result;
import com.buschmais.jqassistant.core.analysis.api.VerificationStrategy;
import com.buschmais.jqassistant.core.analysis.api.rule.AggregationVerification;
import com.buschmais.jqassistant.core.analysis.api.rule.Concept;
import com.buschmais.jqassistant.core.analysis.api.rule.Constraint;
import com.buschmais.jqassistant.core.analysis.api.rule.ExecutableRule;
import java.util.List;
import java.util.Map;

public class AggregationVerificationStrategy
implements VerificationStrategy<AggregationVerification> {
    @Override
    public Class<AggregationVerification> getVerificationType() {
        return AggregationVerification.class;
    }

    @Override
    public <T extends ExecutableRule> Result.Status verify(T executable, AggregationVerification verification, List<String> columnNames, List<Map<String, Object>> rows) throws AnalysisException {
        String column = verification.getColumn();
        if (column == null) {
            column = columnNames.get(0);
        }
        for (Map<String, Object> row : rows) {
            Object value = row.get(column);
            if (value == null || !Number.class.isAssignableFrom(value.getClass())) {
                throw new AnalysisException("The value in column '" + column + "' must be a non-null numeric value but was '" + value + "'");
            }
            int aggregationValue = ((Number)value).intValue();
            if (!(executable instanceof Concept ? aggregationValue == 0 : executable instanceof Constraint && aggregationValue > 0)) continue;
            return Result.Status.FAILURE;
        }
        return Result.Status.SUCCESS;
    }
}

