/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.core.analysis.api.rule;

import com.buschmais.jqassistant.core.analysis.api.RuleException;
import com.buschmais.jqassistant.core.analysis.api.rule.Concept;
import com.buschmais.jqassistant.core.analysis.api.rule.Constraint;
import com.buschmais.jqassistant.core.analysis.api.rule.Group;
import com.buschmais.jqassistant.core.analysis.api.rule.MetricGroup;
import com.buschmais.jqassistant.core.analysis.api.rule.Rule;
import com.buschmais.jqassistant.core.analysis.api.rule.RuleSet;
import com.buschmais.jqassistant.core.analysis.api.rule.Template;
import java.util.HashMap;
import java.util.Map;

public class RuleSetBuilder {
    private DefaultRuleSet ruleSet = new DefaultRuleSet();

    private RuleSetBuilder() {
    }

    public static RuleSetBuilder newInstance() {
        return new RuleSetBuilder();
    }

    public RuleSetBuilder addTemplate(Template template) throws RuleException {
        return this.put(this.ruleSet.templates, template);
    }

    public RuleSetBuilder addConcept(Concept concept) throws RuleException {
        return this.put(this.ruleSet.concepts, concept);
    }

    public RuleSetBuilder addConstraint(Constraint constraint) throws RuleException {
        return this.put(this.ruleSet.constraints, constraint);
    }

    public RuleSetBuilder addGroup(Group group) throws RuleException {
        return this.put(this.ruleSet.groups, group);
    }

    public RuleSetBuilder addMetricGroup(MetricGroup metricGroup) throws RuleException {
        return this.put(this.ruleSet.metricGroups, metricGroup);
    }

    public RuleSet getRuleSet() {
        return this.ruleSet;
    }

    private <T extends Rule> RuleSetBuilder put(Map<String, T> rules, T rule) throws RuleException {
        Rule oldRule = (Rule)rules.put(rule.getId(), rule);
        if (oldRule != null) {
            throw new RuleException("The id of a rule must be unique: type=" + rule.getClass().getSimpleName() + ", id='" + rule.getId() + "', sources='" + rule.getSource() + "' and '" + oldRule.getSource() + "' .");
        }
        return this;
    }

    private static class DefaultRuleSet
    implements RuleSet {
        private Map<String, Template> templates = new HashMap<String, Template>();
        private Map<String, Concept> concepts = new HashMap<String, Concept>();
        private Map<String, Constraint> constraints = new HashMap<String, Constraint>();
        private Map<String, Group> groups = new HashMap<String, Group>();
        private Map<String, MetricGroup> metricGroups = new HashMap<String, MetricGroup>();

        private DefaultRuleSet() {
        }

        @Override
        public Map<String, Template> getTemplates() {
            return this.templates;
        }

        @Override
        public Map<String, Concept> getConcepts() {
            return this.concepts;
        }

        @Override
        public Map<String, Constraint> getConstraints() {
            return this.constraints;
        }

        @Override
        public Map<String, Group> getGroups() {
            return this.groups;
        }

        @Override
        public Map<String, MetricGroup> getMetricGroups() {
            return this.metricGroups;
        }

        public String toString() {
            return "RuleSet{groups=" + this.groups + ", constraints=" + this.constraints + ", concepts=" + this.concepts + '}';
        }
    }
}

