/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.core.store.impl;

import com.buschmais.jqassistant.core.store.impl.AbstractGraphStore;
import com.buschmais.xo.api.XOManager;
import com.buschmais.xo.api.XOManagerFactory;
import com.buschmais.xo.api.bootstrap.XO;
import com.buschmais.xo.api.bootstrap.XOUnit;
import com.buschmais.xo.api.bootstrap.XOUnitBuilder;
import com.buschmais.xo.neo4j.api.Neo4jXOProvider;
import com.buschmais.xo.neo4j.impl.datastore.EmbeddedNeo4jDatastoreSession;
import java.io.File;
import java.net.URI;
import java.util.Collection;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.kernel.GraphDatabaseAPI;
import org.neo4j.tooling.GlobalGraphOperations;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmbeddedGraphStore
extends AbstractGraphStore {
    private static final Logger LOGGER = LoggerFactory.getLogger(EmbeddedGraphStore.class);
    private static final String PROPERTY_NEO4J_CACHE_TYPE = "neo4j.cache_type";
    private static final String VALUE_NEO4J_CACHE_TYPE_NONE = "none";
    private static final String PROPERTY_NEO4J_ALLOW_STORE_UPGRADE = "neo4j.allow_store_upgrade";
    private static final String PROPERTY_NEO4J_KEEP_LOGICAL_LOGS = "neo4j.keep_logical_logs";
    private static final String PROPERTY_NEO4J_LOCK_MANAGER = "neo4j.lock_manager";
    private static final String PROPERTY_NEO4J_DBMS_PAGE_CACHE_MEMORY = "neo4j.dbms.pagecache.memory";
    private final String databaseDirectory;

    public EmbeddedGraphStore(String databaseDirectory) {
        this.databaseDirectory = databaseDirectory;
    }

    protected GraphDatabaseAPI getGraphDatabaseService(XOManager xoManager) {
        return (GraphDatabaseAPI)((EmbeddedNeo4jDatastoreSession)xoManager.getDatastoreSession(EmbeddedNeo4jDatastoreSession.class)).getGraphDatabaseService();
    }

    @Override
    protected XOManagerFactory createXOManagerFactory(Collection<Class<?>> types) {
        File database = new File(this.databaseDirectory);
        XOUnit xoUnit = XOUnitBuilder.create((URI)database.toURI(), Neo4jXOProvider.class, (Class[])types.toArray(new Class[0])).property(PROPERTY_NEO4J_CACHE_TYPE, (Object)VALUE_NEO4J_CACHE_TYPE_NONE).property(PROPERTY_NEO4J_ALLOW_STORE_UPGRADE, (Object)Boolean.TRUE.toString()).property(PROPERTY_NEO4J_KEEP_LOGICAL_LOGS, (Object)Boolean.FALSE.toString()).property(PROPERTY_NEO4J_LOCK_MANAGER, (Object)"NoOp").property(PROPERTY_NEO4J_DBMS_PAGE_CACHE_MEMORY, (Object)"100M").create();
        return XO.createXOManagerFactory((XOUnit)xoUnit);
    }

    @Override
    protected void closeXOManagerFactory(XOManagerFactory xoManagerFactory) {
        xoManagerFactory.close();
    }

    @Override
    public void reset() {
        LOGGER.info("Resetting store.");
        GlobalGraphOperations graphOperations = GlobalGraphOperations.at((GraphDatabaseService)this.getGraphDatabaseService());
        this.beginTransaction();
        LOGGER.debug("Deleting relations...");
        this.run(graphOperations.getAllRelationships(), new Operation<Relationship>(){

            @Override
            public void execute(Relationship value) {
                value.delete();
            }
        });
        LOGGER.debug("Deleting nodes...");
        this.run((Iterable)graphOperations.getAllNodes(), new Operation<Node>(){

            @Override
            public void execute(Node value) {
                value.delete();
            }
        });
        this.commitTransaction();
        LOGGER.info("Reset finished.");
    }

    private <T> void run(Iterable<T> iterable, Operation<T> operation) {
        int count = 0;
        for (T value : iterable) {
            operation.execute(value);
            if (++count % 4096 != 0) continue;
            this.commitTransaction();
            this.beginTransaction();
        }
    }

    static interface Operation<T> {
        public void execute(T var1);
    }
}

