/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.core.store.impl;

import com.buschmais.jqassistant.core.store.api.Store;
import com.buschmais.jqassistant.core.store.api.model.Descriptor;
import com.buschmais.jqassistant.core.store.api.model.FullQualifiedNameDescriptor;
import com.buschmais.xo.api.Query;
import com.buschmais.xo.api.ResultIterable;
import com.buschmais.xo.api.XOManager;
import com.buschmais.xo.api.XOManagerFactory;
import java.util.Collection;
import java.util.Map;
import org.neo4j.graphdb.GraphDatabaseService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractGraphStore
implements Store {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractGraphStore.class);
    private static final int AUTOCOMMIT_THRESHOLD = 32678;
    private XOManagerFactory xoManagerFactory;
    private XOManager xoManager;
    private int created;

    @Override
    public void start(Collection<Class<?>> types) {
        this.xoManagerFactory = this.createXOManagerFactory(types);
        this.xoManager = this.xoManagerFactory.createXOManager();
    }

    @Override
    public void stop() {
        if (this.xoManager != null) {
            if (this.xoManager.currentTransaction().isActive()) {
                LOGGER.warn("Rolling back an active transaction.");
                this.xoManager.currentTransaction().rollback();
            }
            this.xoManager.close();
        }
        if (this.xoManagerFactory != null) {
            this.closeXOManagerFactory(this.xoManagerFactory);
        }
    }

    @Override
    public <T extends Descriptor> T create(Class<T> type) {
        Descriptor descriptor = (Descriptor)this.xoManager.create(type);
        this.autoCommit();
        return (T)descriptor;
    }

    @Override
    public <S extends Descriptor, R extends Descriptor, T extends Descriptor> R create(S source, Class<R> relationType, T target) {
        Descriptor descriptor = (Descriptor)this.xoManager.create(source, relationType, target);
        return (R)descriptor;
    }

    private void autoCommit() {
        ++this.created;
        if (this.created == 32678) {
            this.commitTransaction();
            this.beginTransaction();
        }
    }

    @Override
    public <T extends FullQualifiedNameDescriptor> T create(Class<T> type, String fullQualifiedName) {
        FullQualifiedNameDescriptor descriptor = (FullQualifiedNameDescriptor)this.create(type);
        descriptor.setFullQualifiedName(fullQualifiedName);
        return (T)descriptor;
    }

    @Override
    public <T extends Descriptor> void delete(T descriptor) {
        this.xoManager.delete(descriptor);
    }

    @Override
    public <T extends Descriptor, C> C migrate(T descriptor, Class<C> concreteType, Class<?> ... types) {
        return (C)this.xoManager.migrate(descriptor, concreteType, (Class[])types).as(concreteType);
    }

    @Override
    public <T extends Descriptor, N extends Descriptor> N addDescriptorType(T descriptor, Class<?> newDescriptorType, Class<N> as) {
        return (N)((Descriptor)this.xoManager.migrate(descriptor).add(newDescriptorType, new Class[0]).as(as));
    }

    @Override
    public <T extends Descriptor, N extends Descriptor> N addDescriptorType(T descriptor, Class<N> newDescriptorType) {
        return (N)((Descriptor)this.xoManager.migrate(descriptor).add(newDescriptorType, new Class[0]).as(newDescriptorType));
    }

    @Override
    public <T extends Descriptor, N extends Descriptor> N removeDescriptorType(T descriptor, Class<?> obsoleteDescriptorType, Class<N> as) {
        return (N)((Descriptor)this.xoManager.migrate(descriptor).remove(obsoleteDescriptorType, new Class[0]).as(as));
    }

    @Override
    public <T extends Descriptor> T find(Class<T> type, String fullQualifiedName) {
        ResultIterable result = this.xoManager.find(type, (Object)fullQualifiedName);
        return (T)(result.hasResult() ? (Descriptor)result.getSingleResult() : null);
    }

    @Override
    public Query.Result<Query.Result.CompositeRowObject> executeQuery(String query, Map<String, Object> parameters) {
        return this.xoManager.createQuery(query).withParameters(parameters).execute();
    }

    @Override
    public <Q> Query.Result<Q> executeQuery(Class<Q> query, Map<String, Object> parameters) {
        return this.xoManager.createQuery(query).withParameters(parameters).execute();
    }

    @Override
    public Query.Result<Query.Result.CompositeRowObject> executeQuery(String query) {
        return this.xoManager.createQuery(query).execute();
    }

    @Override
    public void beginTransaction() {
        this.xoManager.currentTransaction().begin();
        this.created = 0;
    }

    @Override
    public void commitTransaction() {
        this.xoManager.currentTransaction().commit();
    }

    @Override
    public void rollbackTransaction() {
        this.xoManager.currentTransaction().rollback();
    }

    @Override
    public GraphDatabaseService getGraphDatabaseService() {
        return this.getGraphDatabaseService(this.xoManager);
    }

    protected abstract GraphDatabaseService getGraphDatabaseService(XOManager var1);

    protected abstract XOManagerFactory createXOManagerFactory(Collection<Class<?>> var1);

    protected abstract void closeXOManagerFactory(XOManagerFactory var1);
}

