/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.store;

import java.io.File;
import java.io.IOException;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.Service;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.api.labelscan.LabelScanStore;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.extension.KernelExtensionFactory;
import org.neo4j.kernel.extension.KernelExtensions;
import org.neo4j.kernel.extension.UnsatisfiedDependencyStrategies;
import org.neo4j.kernel.impl.api.scan.LabelScanStoreProvider;
import org.neo4j.kernel.impl.store.NeoStore;
import org.neo4j.kernel.impl.store.NodeStore;
import org.neo4j.kernel.impl.store.PropertyStore;
import org.neo4j.kernel.impl.store.RelationshipGroupStore;
import org.neo4j.kernel.impl.store.RelationshipStore;
import org.neo4j.kernel.impl.store.StoreFactory;
import org.neo4j.kernel.impl.store.UnderlyingStorageException;
import org.neo4j.kernel.impl.store.counts.CountsTracker;
import org.neo4j.kernel.impl.transaction.state.NeoStoreProvider;
import org.neo4j.kernel.impl.util.Dependencies;
import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.logging.Logging;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.unsafe.impl.batchimport.AdditionalInitialIds;
import org.neo4j.unsafe.impl.batchimport.Configuration;
import org.neo4j.unsafe.impl.batchimport.store.BatchingIdGeneratorFactory;
import org.neo4j.unsafe.impl.batchimport.store.BatchingPageCache;
import org.neo4j.unsafe.impl.batchimport.store.BatchingTokenRepository;
import org.neo4j.unsafe.impl.batchimport.store.io.Monitor;

public class BatchingNeoStore
implements AutoCloseable,
NeoStoreProvider {
    private final FileSystemAbstraction fileSystem;
    private final Monitors monitors;
    private final BatchingTokenRepository.BatchingPropertyKeyTokenRepository propertyKeyRepository;
    private final BatchingTokenRepository.BatchingLabelTokenRepository labelRepository;
    private final BatchingTokenRepository.BatchingRelationshipTypeTokenRepository relationshipTypeRepository;
    private final StringLogger logger;
    private final Config neo4jConfig;
    private final BatchingPageCache pageCache;
    private final NeoStore neoStore;
    private final BatchingPageCache.WriterFactory writerFactory;
    private final LifeSupport life = new LifeSupport();
    private final LabelScanStore labelScanStore;

    public BatchingNeoStore(FileSystemAbstraction fileSystem, File storeDir, Configuration config, Monitor writeMonitor, Logging logging, Monitors monitors, BatchingPageCache.WriterFactory writerFactory, AdditionalInitialIds initialIds) {
        this.fileSystem = fileSystem;
        this.monitors = monitors;
        this.writerFactory = writerFactory;
        this.logger = logging.getMessagesLog(this.getClass());
        this.neo4jConfig = StoreFactory.configForStoreDir(new Config(MapUtil.stringMap(GraphDatabaseSettings.dense_node_threshold.name(), String.valueOf(config.denseNodeThreshold())), GraphDatabaseSettings.class), storeDir);
        this.pageCache = new BatchingPageCache(fileSystem, config.fileChannelBufferSize(), config.bigFileChannelBufferSizeMultiplier(), writerFactory, writeMonitor);
        this.neoStore = this.newNeoStore(this.pageCache);
        this.flushNeoStoreAndAwaitEverythingWritten();
        if (this.alreadyContainsData(this.neoStore)) {
            this.neoStore.close();
            throw new IllegalStateException(storeDir + " already contains data, cannot do import here");
        }
        try {
            this.neoStore.rebuildCountStoreIfNeeded();
        }
        catch (IOException e) {
            throw new UnderlyingStorageException(e);
        }
        this.neoStore.setLastCommittedAndClosedTransactionId(initialIds.lastCommittedTransactionId(), initialIds.lastCommittedTransactionChecksum());
        this.propertyKeyRepository = new BatchingTokenRepository.BatchingPropertyKeyTokenRepository(this.neoStore.getPropertyKeyTokenStore(), initialIds.highPropertyKeyTokenId());
        this.labelRepository = new BatchingTokenRepository.BatchingLabelTokenRepository(this.neoStore.getLabelTokenStore(), initialIds.highLabelTokenId());
        this.relationshipTypeRepository = new BatchingTokenRepository.BatchingRelationshipTypeTokenRepository(this.neoStore.getRelationshipTypeTokenStore(), initialIds.highRelationshipTypeTokenId());
        Dependencies dependencies = new Dependencies();
        dependencies.satisfyDependency(this.neo4jConfig);
        dependencies.satisfyDependency(fileSystem);
        dependencies.satisfyDependency(this);
        dependencies.satisfyDependency(logging);
        KernelExtensions extensions = this.life.add(new KernelExtensions(Service.load(KernelExtensionFactory.class), dependencies, UnsatisfiedDependencyStrategies.ignore()));
        this.life.start();
        this.labelScanStore = this.life.add(extensions.resolveDependency(LabelScanStoreProvider.class, LabelScanStoreProvider.HIGHEST_PRIORITIZED).getLabelScanStore());
    }

    private boolean alreadyContainsData(NeoStore neoStore) {
        return neoStore.getNodeStore().getHighId() > 0L || neoStore.getRelationshipStore().getHighId() > 0L;
    }

    public static void createStore(FileSystemAbstraction fileSystem, String storeDir) throws IOException {
        BatchingPageCache pageCache = new BatchingPageCache(fileSystem, Configuration.DEFAULT.fileChannelBufferSize(), Configuration.DEFAULT.bigFileChannelBufferSizeMultiplier(), BatchingPageCache.SYNCHRONOUS, Monitor.NO_MONITOR);
        StoreFactory storeFactory = new StoreFactory(fileSystem, new File(storeDir), pageCache, StringLogger.DEV_NULL, new Monitors());
        storeFactory.createNeoStore().close();
        pageCache.close();
    }

    private NeoStore newNeoStore(PageCache pageCache) {
        StoreFactory storeFactory = new StoreFactory(this.neo4jConfig, new BatchingIdGeneratorFactory(), pageCache, this.fileSystem, this.logger, this.monitors);
        return storeFactory.newNeoStore(true);
    }

    public NodeStore getNodeStore() {
        return this.neoStore.getNodeStore();
    }

    public PropertyStore getPropertyStore() {
        return this.neoStore.getPropertyStore();
    }

    public BatchingTokenRepository.BatchingPropertyKeyTokenRepository getPropertyKeyRepository() {
        return this.propertyKeyRepository;
    }

    public BatchingTokenRepository.BatchingLabelTokenRepository getLabelRepository() {
        return this.labelRepository;
    }

    public BatchingTokenRepository.BatchingRelationshipTypeTokenRepository getRelationshipTypeRepository() {
        return this.relationshipTypeRepository;
    }

    public RelationshipStore getRelationshipStore() {
        return this.neoStore.getRelationshipStore();
    }

    public RelationshipGroupStore getRelationshipGroupStore() {
        return this.neoStore.getRelationshipGroupStore();
    }

    public CountsTracker getCountsStore() {
        return this.neoStore.getCounts();
    }

    @Override
    public void close() {
        this.propertyKeyRepository.close();
        this.labelRepository.close();
        this.relationshipTypeRepository.close();
        this.flushNeoStoreAndAwaitEverythingWritten();
        this.life.shutdown();
        this.neoStore.close();
    }

    private void flushNeoStoreAndAwaitEverythingWritten() {
        this.neoStore.flush();
        this.writerFactory.awaitEverythingWritten();
    }

    public void flush() throws IOException {
        this.pageCache.flushAndForce();
    }

    public long getLastCommittedTransactionId() {
        return this.neoStore.getLastCommittedTransactionId();
    }

    public LabelScanStore getLabelScanStore() {
        return this.labelScanStore;
    }

    @Override
    public NeoStore evaluate() {
        return this.neoStore;
    }
}

