/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log;

import java.io.IOException;
import org.neo4j.kernel.impl.transaction.log.LogFileInformation;
import org.neo4j.kernel.impl.transaction.log.PhysicalLogFiles;
import org.neo4j.kernel.impl.transaction.log.TransactionIdStore;
import org.neo4j.kernel.impl.transaction.log.TransactionMetadataCache;

public class PhysicalLogFileInformation
implements LogFileInformation {
    private final PhysicalLogFiles logFiles;
    private final TransactionMetadataCache transactionMetadataCache;
    private final TransactionIdStore transactionIdStore;
    private final SPI spi;

    public PhysicalLogFileInformation(PhysicalLogFiles logFiles, TransactionMetadataCache transactionMetadataCache, TransactionIdStore transactionIdStore, SPI spi) {
        this.logFiles = logFiles;
        this.transactionMetadataCache = transactionMetadataCache;
        this.transactionIdStore = transactionIdStore;
        this.spi = spi;
    }

    @Override
    public long getFirstExistingTxId() throws IOException {
        long version = this.logFiles.getHighestLogVersion();
        long candidateFirstTx = -1L;
        while (this.logFiles.versionExists(version)) {
            candidateFirstTx = this.getFirstCommittedTxId(version);
            --version;
        }
        return this.logFiles.hasAnyTransaction(++version) ? candidateFirstTx : -1L;
    }

    @Override
    public long getFirstCommittedTxId(long version) throws IOException {
        long logHeader = this.transactionMetadataCache.getLogHeader(version);
        if (logHeader != -1L) {
            return logHeader + 1L;
        }
        if (this.logFiles.versionExists(version)) {
            long previousVersionLastCommittedTx = this.logFiles.extractHeader((long)version).lastCommittedTxId;
            this.transactionMetadataCache.putHeader(version, previousVersionLastCommittedTx);
            return previousVersionLastCommittedTx + 1L;
        }
        return -1L;
    }

    @Override
    public long getLastCommittedTxId() {
        return this.transactionIdStore.getLastCommittedTransactionId();
    }

    @Override
    public long getFirstStartRecordTimestamp(long version) throws IOException {
        return this.spi.getTimestampForVersion(version);
    }

    public static interface SPI {
        public long getTimestampForVersion(long var1) throws IOException;
    }
}

