/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.plugin.java.impl.scanner.visitor;

import com.buschmais.jqassistant.plugin.java.api.model.AnnotationValueDescriptor;
import com.buschmais.jqassistant.plugin.java.api.model.FieldDescriptor;
import com.buschmais.jqassistant.plugin.java.api.model.MethodDescriptor;
import com.buschmais.jqassistant.plugin.java.api.model.ParameterDescriptor;
import com.buschmais.jqassistant.plugin.java.api.scanner.SignatureHelper;
import com.buschmais.jqassistant.plugin.java.api.scanner.TypeCache;
import com.buschmais.jqassistant.plugin.java.impl.scanner.visitor.AnnotationDefaultVisitor;
import com.buschmais.jqassistant.plugin.java.impl.scanner.visitor.AnnotationVisitor;
import com.buschmais.jqassistant.plugin.java.impl.scanner.visitor.DependentTypeSignatureVisitor;
import com.buschmais.jqassistant.plugin.java.impl.scanner.visitor.VisitorHelper;
import org.objectweb.asm.Label;
import org.objectweb.asm.Type;
import org.objectweb.asm.signature.SignatureReader;
import org.objectweb.asm.signature.SignatureVisitor;

public class MethodVisitor
extends org.objectweb.asm.MethodVisitor {
    private TypeCache.CachedType containingType;
    private MethodDescriptor methodDescriptor;
    private VisitorHelper visitorHelper;
    private int syntheticParameters = 0;
    private int cyclomaticComplexity = 1;
    private int line;

    protected MethodVisitor(TypeCache.CachedType containingType, MethodDescriptor methodDescriptor, VisitorHelper visitorHelper) {
        super(327680);
        this.containingType = containingType;
        this.methodDescriptor = methodDescriptor;
        this.visitorHelper = visitorHelper;
    }

    public org.objectweb.asm.AnnotationVisitor visitParameterAnnotation(int parameter, String desc, boolean visible) {
        String annotationType = SignatureHelper.getType(desc);
        if ("java.lang.Synthetic".equals(annotationType)) {
            ++this.syntheticParameters;
            return null;
        }
        ParameterDescriptor parameterDescriptor = this.visitorHelper.getParameterDescriptor(this.methodDescriptor, parameter - this.syntheticParameters);
        AnnotationValueDescriptor annotationDescriptor = this.visitorHelper.addAnnotation(this.containingType, parameterDescriptor, SignatureHelper.getType(desc));
        return new AnnotationVisitor(this.containingType, annotationDescriptor, this.visitorHelper);
    }

    public void visitTypeInsn(int opcode, String type) {
        this.visitorHelper.resolveType(SignatureHelper.getObjectType(type), this.containingType);
    }

    public void visitFieldInsn(int opcode, String owner, String name, String desc) {
        String fieldSignature = SignatureHelper.getFieldSignature(name, desc);
        TypeCache.CachedType targetType = this.visitorHelper.resolveType(SignatureHelper.getObjectType(owner), this.containingType);
        FieldDescriptor fieldDescriptor = this.visitorHelper.getFieldDescriptor(targetType, fieldSignature);
        switch (opcode) {
            case 178: 
            case 180: {
                this.visitorHelper.addReads(this.methodDescriptor, this.line, fieldDescriptor);
                break;
            }
            case 179: 
            case 181: {
                this.visitorHelper.addWrites(this.methodDescriptor, this.line, fieldDescriptor);
            }
        }
    }

    public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
        String methodSignature = SignatureHelper.getMethodSignature(name, desc);
        TypeCache.CachedType targetType = this.visitorHelper.resolveType(SignatureHelper.getObjectType(owner), this.containingType);
        MethodDescriptor invokedMethodDescriptor = this.visitorHelper.getMethodDescriptor(targetType, methodSignature);
        this.visitorHelper.addInvokes(this.methodDescriptor, this.line, invokedMethodDescriptor);
    }

    public void visitLdcInsn(Object cst) {
        if (cst instanceof Type) {
            this.visitorHelper.resolveType(SignatureHelper.getType((Type)cst), this.containingType);
        }
    }

    public void visitMultiANewArrayInsn(String desc, int dims) {
        this.visitorHelper.resolveType(SignatureHelper.getType(desc), this.containingType);
    }

    public void visitLocalVariable(String name, String desc, String signature, Label start, Label end, int index) {
        if (signature != null) {
            new SignatureReader(signature).accept((SignatureVisitor)new DependentTypeSignatureVisitor(this.containingType, this.visitorHelper));
        }
    }

    public org.objectweb.asm.AnnotationVisitor visitAnnotationDefault() {
        return new AnnotationDefaultVisitor(this.containingType, this.methodDescriptor, this.visitorHelper);
    }

    public void visitTryCatchBlock(Label start, Label end, Label handler, String type) {
        if (type != null) {
            String fullQualifiedName = SignatureHelper.getObjectType(type);
            this.visitorHelper.resolveType(fullQualifiedName, this.containingType);
        }
    }

    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        AnnotationValueDescriptor annotationDescriptor = this.visitorHelper.addAnnotation(this.containingType, this.methodDescriptor, SignatureHelper.getType(desc));
        return new AnnotationVisitor(this.containingType, annotationDescriptor, this.visitorHelper);
    }

    public void visitLineNumber(int line, Label start) {
        this.line = line;
    }

    public void visitJumpInsn(int opcode, Label label) {
        ++this.cyclomaticComplexity;
    }

    public void visitEnd() {
        this.methodDescriptor.setCyclomaticComplexity(this.cyclomaticComplexity);
    }
}

