/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.plugin.java.api.scanner;

import com.buschmais.jqassistant.core.scanner.api.ScannerContext;
import com.buschmais.jqassistant.core.scanner.api.Scope;
import com.buschmais.jqassistant.core.store.api.model.Descriptor;
import com.buschmais.jqassistant.plugin.common.api.scanner.FileResolver;
import com.buschmais.jqassistant.plugin.common.api.scanner.FileResolverStrategy;
import com.buschmais.jqassistant.plugin.java.api.model.JavaArtifactFileDescriptor;
import com.buschmais.jqassistant.plugin.java.api.scanner.ClasspathScopedTypeResolver;
import com.buschmais.jqassistant.plugin.java.api.scanner.DefaultTypeResolver;
import com.buschmais.jqassistant.plugin.java.api.scanner.DelegatingTypeResolver;
import com.buschmais.jqassistant.plugin.java.api.scanner.TypeResolver;

public enum JavaScope implements Scope
{
    CLASSPATH{

        public void create(ScannerContext context) {
            TypeResolver typeResolver = this.getTypeResolver(context);
            ((FileResolver)context.peek(FileResolver.class)).push((FileResolverStrategy)new ClassFileResolverStrategy());
            context.push(TypeResolver.class, (Object)typeResolver);
        }

        public void destroy(ScannerContext context) {
            ((FileResolver)context.peek(FileResolver.class)).pop();
            context.pop(TypeResolver.class);
        }

        private TypeResolver getTypeResolver(ScannerContext context) {
            TypeResolver typeResolver = (TypeResolver)context.peek(TypeResolver.class);
            if (typeResolver != null) {
                return new DelegatingTypeResolver(typeResolver);
            }
            JavaArtifactFileDescriptor artifactDescriptor = (JavaArtifactFileDescriptor)context.peek(JavaArtifactFileDescriptor.class);
            if (artifactDescriptor != null) {
                return new ClasspathScopedTypeResolver(artifactDescriptor);
            }
            return new DefaultTypeResolver();
        }
    };


    public String getPrefix() {
        return "java";
    }

    public String getName() {
        return this.name();
    }

    private static class ClassFileResolverStrategy
    implements FileResolverStrategy {
        private static final String CLASS_SUFFIX = ".class";

        private ClassFileResolverStrategy() {
        }

        public Descriptor require(String path, ScannerContext context) {
            return null;
        }

        public Descriptor match(String path, ScannerContext context) {
            if (path.toLowerCase().endsWith(CLASS_SUFFIX)) {
                String typeName = path.substring(1, path.length() - CLASS_SUFFIX.length()).replaceAll("/", ".");
                TypeResolver typeResolver = (TypeResolver)context.peek(TypeResolver.class);
                return typeResolver.resolve(typeName, context).getTypeDescriptor();
            }
            return null;
        }
    }
}

