/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.compiler.v2_2;

import org.neo4j.cypher.internal.compiler.v2_2.CypherException;
import org.neo4j.cypher.internal.compiler.v2_2.InputPosition;
import org.neo4j.cypher.internal.compiler.v2_2.InternalException;
import org.neo4j.cypher.internal.compiler.v2_2.InternalException$;
import org.neo4j.cypher.internal.compiler.v2_2.ScopeTreeVerifier$;
import org.neo4j.cypher.internal.compiler.v2_2.SemanticCheckMonitor;
import org.neo4j.cypher.internal.compiler.v2_2.SemanticCheckResult;
import org.neo4j.cypher.internal.compiler.v2_2.SemanticError;
import org.neo4j.cypher.internal.compiler.v2_2.SemanticState;
import org.neo4j.cypher.internal.compiler.v2_2.SemanticState$;
import org.neo4j.cypher.internal.compiler.v2_2.ast.Statement;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.Nothing$;

@ScalaSignature(bytes="\u0006\u0001\r3A!\u0001\u0002\u0001\u001f\ty1+Z7b]RL7m\u00115fG.,'O\u0003\u0002\u0004\t\u0005!aOM03\u0015\t)a!\u0001\u0005d_6\u0004\u0018\u000e\\3s\u0015\t9\u0001\"\u0001\u0005j]R,'O\\1m\u0015\tI!\"\u0001\u0004dsBDWM\u001d\u0006\u0003\u00171\tQA\\3pi)T\u0011!D\u0001\u0004_J<7\u0001A\n\u0003\u0001A\u0001\"!\u0005\u000b\u000e\u0003IQ\u0011aE\u0001\u0006g\u000e\fG.Y\u0005\u0003+I\u0011a!\u00118z%\u00164\u0007\u0002C\f\u0001\u0005\u0003\u0005\u000b\u0011\u0002\r\u0002)M,W.\u00198uS\u000e\u001c\u0005.Z2l\u001b>t\u0017\u000e^8s!\tI\"$D\u0001\u0003\u0013\tY\"A\u0001\u000bTK6\fg\u000e^5d\u0007\",7m['p]&$xN\u001d\u0005\u0006;\u0001!\tAH\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005}\u0001\u0003CA\r\u0001\u0011\u00159B\u00041\u0001\u0019\u0011\u0015\u0011\u0003\u0001\"\u0001$\u0003\u0015\u0019\u0007.Z2l)\u0011!s\u0005\r\u001d\u0011\u0005e)\u0013B\u0001\u0014\u0003\u00055\u0019V-\\1oi&\u001c7\u000b^1uK\")\u0001&\ta\u0001S\u0005I\u0011/^3ssR+\u0007\u0010\u001e\t\u0003U5r!!E\u0016\n\u00051\u0012\u0012A\u0002)sK\u0012,g-\u0003\u0002/_\t11\u000b\u001e:j]\u001eT!\u0001\f\n\t\u000bE\n\u0003\u0019\u0001\u001a\u0002\u0013M$\u0018\r^3nK:$\bCA\u001a7\u001b\u0005!$BA\u001b\u0003\u0003\r\t7\u000f^\u0005\u0003oQ\u0012\u0011b\u0015;bi\u0016lWM\u001c;\t\u000be\n\u0003\u0019\u0001\u001e\u0002\u00175\\W\t_2faRLwN\u001c\t\u0006#mJS\bQ\u0005\u0003yI\u0011\u0011BR;oGRLwN\u001c\u001a\u0011\u0005eq\u0014BA \u0003\u00055Ie\u000e];u!>\u001c\u0018\u000e^5p]B\u0011\u0011$Q\u0005\u0003\u0005\n\u0011qbQ=qQ\u0016\u0014X\t_2faRLwN\u001c")
public class SemanticChecker {
    private final SemanticCheckMonitor semanticCheckMonitor;

    public SemanticState check(String queryText, Statement statement, Function2<String, InputPosition, CypherException> mkException) {
        this.semanticCheckMonitor.startSemanticCheck(queryText);
        SemanticCheckResult semanticCheckResult = (SemanticCheckResult)statement.semanticCheck().apply((Object)SemanticState$.MODULE$.clean());
        if (semanticCheckResult != null) {
            Tuple2 tuple2;
            SemanticState semanticState = semanticCheckResult.state();
            Seq<SemanticError> semanticErrors = semanticCheckResult.errors();
            Tuple2 tuple22 = tuple2 = new Tuple2((Object)semanticState, semanticErrors);
            SemanticState semanticState2 = (SemanticState)tuple22._1();
            Seq semanticErrors2 = (Seq)tuple22._2();
            Seq<String> scopeTreeIssues = ScopeTreeVerifier$.MODULE$.verify(semanticState2.scopeTree());
            if (scopeTreeIssues.nonEmpty()) {
                throw new InternalException(scopeTreeIssues.mkString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\\n"})).s((Seq)Nil$.MODULE$)), InternalException$.MODULE$.$lessinit$greater$default$2());
            }
            if (semanticErrors2.nonEmpty()) {
                this.semanticCheckMonitor.finishSemanticCheckError(queryText, (Seq<SemanticError>)semanticErrors2);
            } else {
                this.semanticCheckMonitor.finishSemanticCheckSuccess(queryText);
            }
            semanticErrors2.map((Function1)new Serializable(this, mkException){
                public static final long serialVersionUID = 0L;
                private final Function2 mkException$1;

                public final Nothing$ apply(SemanticError error) {
                    throw (Throwable)this.mkException$1.apply((Object)error.msg(), (Object)error.position());
                }
                {
                    this.mkException$1 = mkException$1;
                }
            }, Seq$.MODULE$.canBuildFrom());
            return semanticState2;
        }
        throw new MatchError((Object)semanticCheckResult);
    }

    public SemanticChecker(SemanticCheckMonitor semanticCheckMonitor) {
        this.semanticCheckMonitor = semanticCheckMonitor;
    }
}

