/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.core.osgitools;

import java.io.File;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.project.MavenProject;
import org.eclipse.tycho.BuildOutputDirectory;
import org.eclipse.tycho.ReactorProject;
import org.eclipse.tycho.ReactorProjectIdentities;
import org.eclipse.tycho.osgi.adapters.MavenReactorProjectIdentities;

public class DefaultReactorProject
implements ReactorProject {
    private final MavenProject project;

    public DefaultReactorProject(MavenProject project) {
        if (project == null) {
            throw new NullPointerException();
        }
        this.project = project;
    }

    public static ReactorProject adapt(MavenProject project) {
        if (project == null) {
            return null;
        }
        ReactorProject reactorProject = (ReactorProject)project.getContextValue("tycho.reactor-project");
        if (reactorProject == null) {
            reactorProject = new DefaultReactorProject(project);
            project.setContextValue("tycho.reactor-project", (Object)reactorProject);
        }
        return reactorProject;
    }

    public static List<ReactorProject> adapt(MavenSession session) {
        ArrayList<ReactorProject> result = new ArrayList<ReactorProject>();
        for (MavenProject project : session.getProjects()) {
            result.add(DefaultReactorProject.adapt(project));
        }
        return result;
    }

    public boolean sameProject(Object otherProject) {
        return this.project.equals(otherProject);
    }

    public File getBasedir() {
        return this.project.getBasedir();
    }

    public String getPackaging() {
        return this.project.getPackaging();
    }

    public String getGroupId() {
        return this.project.getGroupId();
    }

    public String getArtifactId() {
        return this.project.getArtifactId();
    }

    public String getVersion() {
        return this.project.getVersion();
    }

    public ReactorProjectIdentities getIdentities() {
        return new MavenReactorProjectIdentities(this.project);
    }

    public File getOutputDirectory() {
        return new File(this.project.getBuild().getOutputDirectory());
    }

    public BuildOutputDirectory getBuildDirectory() {
        return new BuildOutputDirectory(this.project.getBuild().getDirectory());
    }

    public File getTestOutputDirectory() {
        return new File(this.project.getBuild().getTestOutputDirectory());
    }

    public File getArtifact() {
        Artifact artifact = this.project.getArtifact();
        return artifact != null ? artifact.getFile() : null;
    }

    public File getArtifact(String artifactClassifier) {
        Artifact artifact = null;
        if (artifactClassifier == null) {
            artifact = this.project.getArtifact();
        } else {
            for (Artifact attached : this.project.getAttachedArtifacts()) {
                if (!artifactClassifier.equals(attached.getClassifier())) continue;
                artifact = attached;
                break;
            }
        }
        return artifact != null ? artifact.getFile() : null;
    }

    public Object getContextValue(String key) {
        return this.project.getContextValue(key);
    }

    public void setContextValue(String key, Object value) {
        this.project.setContextValue(key, value);
    }

    public void setDependencyMetadata(boolean primary, Set<?> installableUnits) {
        this.project.setContextValue(DefaultReactorProject.getDependencyMetadataKey(primary), installableUnits);
    }

    public Set<?> getDependencyMetadata() {
        Set<?> primary = this.getDependencyMetadata(true);
        Set<?> secondary = this.getDependencyMetadata(false);
        if (primary == null) {
            return secondary;
        }
        if (secondary == null) {
            return primary;
        }
        LinkedHashSet result = new LinkedHashSet(primary);
        result.addAll(secondary);
        return result;
    }

    public Set<?> getDependencyMetadata(boolean primary) {
        Set metadata = (Set)this.project.getContextValue(DefaultReactorProject.getDependencyMetadataKey(primary));
        return metadata;
    }

    private static String getDependencyMetadataKey(boolean primary) {
        return primary ? "tycho.dependency-metadata" : "tycho.secondary-dependency-metadata";
    }

    public String getBuildQualifier() {
        String version = (String)this.project.getProperties().get("buildQualifier");
        if (version != null) {
            return version;
        }
        throw new IllegalStateException("Project " + this.getId() + " does not have a build qualifier");
    }

    public String getExpandedVersion() {
        String version = (String)this.project.getProperties().get("qualifiedVersion");
        if (version != null) {
            return version;
        }
        throw new IllegalStateException("Project " + this.getId() + " does not have an expanded version");
    }

    public String getId() {
        return this.project.getId();
    }

    public int hashCode() {
        return this.project.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof DefaultReactorProject)) {
            return false;
        }
        DefaultReactorProject other = (DefaultReactorProject)obj;
        return this.project.equals((Object)other.project);
    }

    public String toString() {
        return this.project.toString();
    }
}

