/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.core.osgitools;

import java.io.File;
import java.util.Set;
import org.eclipse.tycho.ArtifactDescriptor;
import org.eclipse.tycho.ArtifactKey;
import org.eclipse.tycho.ReactorProject;

public class DefaultArtifactDescriptor
implements ArtifactDescriptor {
    private final ArtifactKey key;
    private final File location;
    private final ReactorProject project;
    private final String classifier;
    private final Set<Object> installableUnits;

    public DefaultArtifactDescriptor(ArtifactKey key, File location, ReactorProject project, String classifier, Set<Object> installableUnits) {
        this.key = key;
        this.location = location;
        this.project = project;
        this.classifier = classifier;
        this.installableUnits = installableUnits;
    }

    public ArtifactKey getKey() {
        return this.key;
    }

    public File getLocation() {
        return this.location;
    }

    public ReactorProject getMavenProject() {
        return this.project;
    }

    public String getClassifier() {
        return this.classifier;
    }

    public Set<Object> getInstallableUnits() {
        return this.installableUnits;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.key.toString()).append(": ");
        if (this.project != null) {
            sb.append(this.project.toString());
        } else {
            sb.append(this.location);
        }
        return sb.toString();
    }

    public int hashCode() {
        int hash = this.key.hashCode();
        hash = 17 * hash + this.location.hashCode();
        hash = 17 * hash + (this.classifier != null ? this.classifier.hashCode() : 0);
        hash = 17 * hash + (this.project != null ? this.project.hashCode() : 0);
        hash = 17 * hash + (this.installableUnits != null ? this.installableUnits.hashCode() : 0);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != DefaultArtifactDescriptor.class) {
            return false;
        }
        DefaultArtifactDescriptor other = (DefaultArtifactDescriptor)obj;
        return DefaultArtifactDescriptor.eq(this.key, other.key) && DefaultArtifactDescriptor.eq(this.location, other.location) && DefaultArtifactDescriptor.eq(this.project, other.project) && DefaultArtifactDescriptor.eq(this.classifier, other.classifier) && DefaultArtifactDescriptor.eq(this.installableUnits, other.installableUnits);
    }

    private static <T> boolean eq(T a, T b) {
        return a != null ? a.equals(b) : b == null;
    }
}

