/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.core.maven;

import java.util.Collections;
import java.util.Map;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.toolchain.MisconfiguredToolchainException;
import org.apache.maven.toolchain.ToolchainManagerPrivate;
import org.apache.maven.toolchain.ToolchainPrivate;
import org.apache.maven.toolchain.java.DefaultJavaToolChain;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;

@Component(role=ToolchainProvider.class)
public class ToolchainProvider {
    @Requirement
    ToolchainManagerPrivate toolChainManager;

    public DefaultJavaToolChain findMatchingJavaToolChain(MavenSession session, String toolchainId) throws MojoExecutionException {
        try {
            Map<String, String> requirements = Collections.singletonMap("id", toolchainId);
            for (ToolchainPrivate javaToolChain : this.toolChainManager.getToolchainsForType("jdk", session)) {
                if (!javaToolChain.matchesRequirements(requirements) || !(javaToolChain instanceof DefaultJavaToolChain)) continue;
                return (DefaultJavaToolChain)javaToolChain;
            }
            return null;
        }
        catch (MisconfiguredToolchainException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
    }

    public static enum JDKUsage {
        SYSTEM,
        BREE;

    }
}

