/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.plugin.graphml.report.impl;

import com.buschmais.jqassistant.core.report.api.ReportHelper;
import com.buschmais.jqassistant.plugin.graphml.report.impl.MetaInformation;
import com.buschmais.jqassistant.plugin.graphml.report.impl.SimpleSubGraph;
import com.buschmais.xo.api.CompositeObject;
import com.sun.xml.txw2.output.IndentingXMLStreamWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;

public class XmlGraphMLWriter {
    private XMLOutputFactory xmlOutputFactory = XMLOutputFactory.newInstance();

    XmlGraphMLWriter() {
    }

    void write(SimpleSubGraph graph, Writer writer) throws IOException, XMLStreamException {
        Collection<CompositeObject> allCoNodes = graph.getAllNodes();
        IndentingXMLStreamWriter xmlWriter = new IndentingXMLStreamWriter(this.xmlOutputFactory.createXMLStreamWriter(writer));
        NamespaceContext context = this.createNamespaceContext();
        if (context != null) {
            xmlWriter.setNamespaceContext(context);
        }
        this.writeHeader((XMLStreamWriter)xmlWriter);
        this.writeDefaultKeys((XMLStreamWriter)xmlWriter);
        this.writeKeyTypes((XMLStreamWriter)xmlWriter, graph);
        this.writeSubgraph(graph, (XMLStreamWriter)xmlWriter);
        HashSet<Long> allNodes = new HashSet<Long>();
        for (CompositeObject compositeObject : allCoNodes) {
            allNodes.add(((Node)compositeObject.getDelegate()).getId());
        }
        for (CompositeObject coRel : graph.getAllRelationships()) {
            Relationship rel = (Relationship)coRel.getDelegate();
            long startId = rel.getStartNode().getId();
            long endId = rel.getEndNode().getId();
            if (!allNodes.contains(startId) || !allNodes.contains(endId)) continue;
            this.writeRelationship((XMLStreamWriter)xmlWriter, coRel);
        }
        this.writeFooter((XMLStreamWriter)xmlWriter);
    }

    protected NamespaceContext createNamespaceContext() {
        return null;
    }

    private void writeSubgraph(SimpleSubGraph graph, XMLStreamWriter writer) throws XMLStreamException, IOException {
        CompositeObject wrapperNode = graph.getParentNode();
        if (wrapperNode != null) {
            this.writeNode(writer, wrapperNode, false);
        }
        writer.writeStartElement("graph");
        writer.writeAttribute("id", "G" + graph.hashCode());
        writer.writeAttribute("edgedefault", "directed");
        this.newLine(writer);
        for (CompositeObject node : graph.getNodes()) {
            this.writeNode(writer, node, true);
        }
        for (SimpleSubGraph subgraph : graph.getSubgraphs()) {
            this.writeSubgraph(subgraph, writer);
        }
        this.endElement(writer);
        if (wrapperNode != null) {
            writer.writeEndElement();
        }
    }

    protected void writeDefaultKeys(XMLStreamWriter writer) throws XMLStreamException {
    }

    private void writeKeyTypes(XMLStreamWriter writer, SimpleSubGraph ops) throws IOException, XMLStreamException {
        HashMap<String, Class> keyTypes = new HashMap<String, Class>();
        keyTypes.put("labels", String.class);
        for (CompositeObject node : ops.getAllNodes()) {
            this.updateKeyTypes(keyTypes, node);
        }
        this.writeKeyTypes(writer, keyTypes, "node");
        keyTypes.clear();
        for (CompositeObject rel : ops.getAllRelationships()) {
            this.updateKeyTypes(keyTypes, rel);
        }
        this.writeKeyTypes(writer, keyTypes, "edge");
    }

    private void writeKeyTypes(XMLStreamWriter writer, Map<String, Class> keyTypes, String forType) throws IOException, XMLStreamException {
        for (Map.Entry<String, Class> entry : keyTypes.entrySet()) {
            String type = MetaInformation.typeFor(entry.getValue(), MetaInformation.GRAPHML_ALLOWED);
            if (type == null) continue;
            writer.writeEmptyElement("key");
            writer.writeAttribute("id", entry.getKey());
            writer.writeAttribute("for", forType);
            writer.writeAttribute("attr.name", entry.getKey());
            writer.writeAttribute("attr.type", type);
            this.newLine(writer);
        }
    }

    private void updateKeyTypes(Map<String, Class> keyTypes, CompositeObject composite) {
        PropertyContainer pc = (PropertyContainer)composite.getDelegate();
        this.updateKeyTypes(keyTypes, pc);
    }

    private void updateKeyTypes(Map<String, Class> keyTypes, PropertyContainer pc) {
        for (String prop : pc.getPropertyKeys()) {
            Object value = pc.getProperty(prop);
            Class storedClass = keyTypes.get(prop);
            if (storedClass == null) {
                keyTypes.put(prop, value.getClass());
                continue;
            }
            if (storedClass == Void.TYPE || storedClass.equals(value.getClass())) continue;
            keyTypes.put(prop, Void.TYPE);
        }
    }

    private int writeNode(XMLStreamWriter writer, CompositeObject composite, boolean withEnd) throws IOException, XMLStreamException {
        Node node = (Node)composite.getDelegate();
        writer.writeStartElement("node");
        writer.writeAttribute("id", this.id(node));
        this.writeAdditionalNodeAttribute(writer, node);
        this.writeLabels(writer, node);
        this.writeLabelsAsData(writer, node);
        this.writeAdditionalNodeData(writer, ReportHelper.getStringValue((Object)composite));
        int props = this.writeProps(writer, (PropertyContainer)node);
        if (withEnd) {
            this.endElement(writer);
        }
        return props;
    }

    protected void writeAdditionalNodeAttribute(XMLStreamWriter writer, Node node) throws XMLStreamException {
    }

    protected void writeAdditionalNodeData(XMLStreamWriter writer, String nodeLabel) throws XMLStreamException {
    }

    private String id(Node node) {
        return "n" + node.getId();
    }

    private void writeLabels(XMLStreamWriter writer, Node node) throws IOException, XMLStreamException {
        String labelsString = MetaInformation.getLabelsString(node);
        if (!labelsString.isEmpty()) {
            writer.writeAttribute("labels", labelsString);
        }
    }

    private void writeLabelsAsData(XMLStreamWriter writer, Node node) throws IOException, XMLStreamException {
        String labelsString = MetaInformation.getLabelsString(node);
        if (labelsString.isEmpty()) {
            return;
        }
        this.writeData(writer, "labels", labelsString);
    }

    private int writeRelationship(XMLStreamWriter writer, CompositeObject coRel) throws IOException, XMLStreamException {
        Relationship rel = (Relationship)coRel.getDelegate();
        writer.writeStartElement("edge");
        writer.writeAttribute("id", this.id(rel));
        writer.writeAttribute("source", this.id(rel.getStartNode()));
        writer.writeAttribute("target", this.id(rel.getEndNode()));
        writer.writeAttribute("label", rel.getType().name());
        this.writeData(writer, "label", rel.getType().name());
        int props = this.writeProps(writer, (PropertyContainer)rel);
        this.endElement(writer);
        return props;
    }

    private String id(Relationship rel) {
        return "e" + rel.getId();
    }

    private void endElement(XMLStreamWriter writer) throws XMLStreamException {
        writer.writeEndElement();
        this.newLine(writer);
    }

    private int writeProps(XMLStreamWriter writer, PropertyContainer node) throws IOException, XMLStreamException {
        int count = 0;
        for (String prop : node.getPropertyKeys()) {
            Object value = node.getProperty(prop);
            this.writeData(writer, prop, value);
            ++count;
        }
        return count;
    }

    private void writeData(XMLStreamWriter writer, String prop, Object value) throws IOException, XMLStreamException {
        writer.writeStartElement("data");
        writer.writeAttribute("key", prop);
        if (value != null) {
            writer.writeCharacters(value.toString());
        }
        writer.writeEndElement();
    }

    private void writeFooter(XMLStreamWriter writer) throws IOException, XMLStreamException {
        this.endElement(writer);
        writer.writeEndDocument();
    }

    private void writeHeader(XMLStreamWriter writer) throws IOException, XMLStreamException {
        writer.writeStartDocument("UTF-8", "1.0");
        this.newLine(writer);
        writer.writeStartElement("graphml");
        writer.writeNamespace("xmlns", "http://graphml.graphdrawing.org/xmlns");
        writer.writeAttribute("xmlns", "http://graphml.graphdrawing.org/xmlns", "xsi", "http://www.w3.org/2001/XMLSchema-instance");
        this.writeAdditionalNamespace(writer);
        writer.writeAttribute("xsi", "", "schemaLocation", "http://graphml.graphdrawing.org/xmlns http://www.yworks.com/xml/schema/graphml/1.1/ygraphml.xsd");
        this.newLine(writer);
    }

    protected void writeAdditionalNamespace(XMLStreamWriter writer) throws XMLStreamException {
    }

    private void newLine(XMLStreamWriter writer) throws XMLStreamException {
        writer.writeCharacters("\n");
    }
}

