/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.plugin.graphml.report.impl;

import com.buschmais.xo.api.CompositeObject;
import java.util.LinkedHashMap;
import java.util.Map;
import org.neo4j.graphdb.DynamicRelationshipType;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;

class VirtualRelationship
implements Relationship {
    static long REL_ID = -1L;
    private final long id;
    private final Node start;
    private final Node end;
    private final RelationshipType type;
    private final Map<String, Object> props = new LinkedHashMap<String, Object>();
    private static final String ROLE_RELATIONSHIP = "relationship";

    public static boolean isRelationship(Map m) {
        return ROLE_RELATIONSHIP.equals(m.get("role"));
    }

    public VirtualRelationship(Map m) {
        long l;
        if (!VirtualRelationship.isRelationship(m)) {
            throw new IllegalArgumentException("Not a relationship-map " + m);
        }
        this.start = this.getDelegate(m.get("startNode"));
        this.end = this.getDelegate(m.get("endNode"));
        this.type = DynamicRelationshipType.withName((String)((String)m.get("type")));
        if (m.containsKey("id")) {
            l = ((Number)m.get("id")).longValue();
        } else {
            long l2 = REL_ID;
            l = l2;
            REL_ID = l2 - 1L;
        }
        this.id = l;
        if (m.containsKey("properties")) {
            this.props.putAll((Map)m.get("properties"));
        }
    }

    private Node getDelegate(Object object) {
        if (object instanceof Node) {
            return (Node)object;
        }
        if (object instanceof CompositeObject) {
            return (Node)((CompositeObject)object).getDelegate();
        }
        return null;
    }

    public long getId() {
        return this.id;
    }

    public void delete() {
    }

    public Node getStartNode() {
        return this.start;
    }

    public Node getEndNode() {
        return this.end;
    }

    public Node getOtherNode(Node node) {
        if (node.equals(this.start)) {
            return this.end;
        }
        if (node.equals(this.end)) {
            return this.start;
        }
        throw new IllegalArgumentException("Node is neither start nor end-node " + node);
    }

    public Node[] getNodes() {
        return new Node[]{this.start, this.end};
    }

    public RelationshipType getType() {
        return this.type;
    }

    public boolean isType(RelationshipType type) {
        return type.name().equals(this.type.name());
    }

    public GraphDatabaseService getGraphDatabase() {
        return null;
    }

    public boolean hasProperty(String key) {
        return this.props.containsKey(key);
    }

    public Object getProperty(String key) {
        return this.props.get(key);
    }

    public Object getProperty(String key, Object defaultValue) {
        return this.props.containsKey(key) ? this.props.get(key) : defaultValue;
    }

    public void setProperty(String key, Object value) {
        this.props.put(key, value);
    }

    public Object removeProperty(String key) {
        return this.props.remove(key);
    }

    public Iterable<String> getPropertyKeys() {
        return this.props.keySet();
    }
}

