/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.plugin.graphml.report.impl;

import com.buschmais.jqassistant.plugin.graphml.report.impl.MetaInformation;
import com.buschmais.xo.api.CompositeObject;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;

class SimpleSubGraph {
    private static final String ROLE_GRAPH = "graph";
    private Set<CompositeObject> nodes = new LinkedHashSet<CompositeObject>(1000);
    private Set<CompositeObject> relationships = new LinkedHashSet<CompositeObject>(1000);
    private CompositeObject parentNode;
    private Set<SimpleSubGraph> subgraphs = new LinkedHashSet<SimpleSubGraph>(1000);

    public SimpleSubGraph() {
    }

    public SimpleSubGraph(Map m) {
        if (!SimpleSubGraph.isSubgraph(m)) {
            throw new IllegalArgumentException("the argument m (" + m + ") is not a subgraph map");
        }
        if (m.containsKey("nodes")) {
            this.add((List)m.get("nodes"));
        }
        if (m.containsKey("relationships")) {
            this.add((List)m.get("relationships"));
        }
        if (m.containsKey("parent")) {
            this.parentNode = (CompositeObject)m.get("parent");
        }
    }

    public CompositeObject getParentNode() {
        return this.parentNode;
    }

    public Iterable<CompositeObject> getNodes() {
        return this.nodes;
    }

    public Collection<CompositeObject> getAllNodes() {
        LinkedHashSet<CompositeObject> allNodes = new LinkedHashSet<CompositeObject>(1000);
        if (this.parentNode != null) {
            allNodes.add(this.parentNode);
        }
        allNodes.addAll(this.nodes);
        for (SimpleSubGraph subgraph : this.subgraphs) {
            allNodes.addAll(subgraph.getAllNodes());
        }
        return allNodes;
    }

    public Iterable<CompositeObject> getRelationships() {
        return this.relationships;
    }

    public Collection<CompositeObject> getAllRelationships() {
        LinkedHashSet<CompositeObject> allRels = new LinkedHashSet<CompositeObject>(1000);
        allRels.addAll(this.relationships);
        for (SimpleSubGraph subgraph : this.subgraphs) {
            allRels.addAll(subgraph.getAllRelationships());
        }
        return allRels;
    }

    public void add(Object value) {
        if (value instanceof CompositeObject) {
            CompositeObject compositeObject = (CompositeObject)value;
            Object o = compositeObject.getDelegate();
            if (o instanceof Node) {
                this.nodes.add(compositeObject);
            } else if (o instanceof Relationship) {
                this.relationships.add(compositeObject);
            } else {
                this.add(o);
            }
        } else if (value instanceof SimpleSubGraph) {
            this.subgraphs.add((SimpleSubGraph)value);
        } else if (value instanceof Relationship) {
            Relationship rel = (Relationship)value;
            this.relationships.add(new RelationWrapper(rel));
        } else if (value instanceof Node) {
            Node node = (Node)value;
            this.nodes.add(new NodeWrapper(node));
        } else if (value instanceof Iterable) {
            for (Object o : (Iterable)value) {
                this.add(o);
            }
        }
    }

    public static boolean isSubgraph(Map m) {
        return ROLE_GRAPH.equals(m.get("role"));
    }

    public Set<SimpleSubGraph> getSubgraphs() {
        return this.subgraphs;
    }

    public boolean contains(Relationship relationship) {
        return this.relationships.contains(relationship);
    }

    private class NodeWrapper
    implements CompositeObject {
        private Node node;

        public NodeWrapper(Node node) {
            this.node = node;
        }

        public Long getId() {
            return this.node.getId();
        }

        public <T> T as(Class<T> type) {
            return null;
        }

        public Node getDelegate() {
            return this.node;
        }

        public String toString() {
            return "VirtualNode[labels=" + MetaInformation.getLabelsString(this.node) + "]";
        }
    }

    private class RelationWrapper
    implements CompositeObject {
        private Relationship rel;

        public RelationWrapper(Relationship rel) {
            this.rel = rel;
        }

        public Long getId() {
            return this.rel.getId();
        }

        public <T> T as(Class<T> type) {
            return null;
        }

        public Relationship getDelegate() {
            return this.rel;
        }

        public String toString() {
            return "VirtualRelationship[type=" + this.rel.getType().name() + "]";
        }
    }
}

