/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.xo.spi.reflection;

import com.buschmais.xo.api.XOException;
import com.buschmais.xo.spi.reflection.AnnotatedMethod;
import com.buschmais.xo.spi.reflection.GetPropertyMethod;
import com.buschmais.xo.spi.reflection.SetPropertyMethod;
import com.buschmais.xo.spi.reflection.UserMethod;
import com.google.common.base.CaseFormat;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public final class BeanMethodProvider {
    private final Class<?> type;
    private final Set<Method> methods = new HashSet<Method>();
    private final Map<String, Method> getters = new HashMap<String, Method>();
    private final Map<String, Method> setters = new HashMap<String, Method>();
    private final Map<String, Class<?>> types = new HashMap();
    private final Map<String, Type> genericTypes = new HashMap<String, Type>();

    private BeanMethodProvider(Class<?> type) {
        this.type = type;
    }

    public static BeanMethodProvider newInstance(Class<?> type) {
        return new BeanMethodProvider(type);
    }

    public Collection<AnnotatedMethod> getMethods() {
        String name;
        for (Method method : this.type.getDeclaredMethods()) {
            String name2;
            String methodName = method.getName();
            Class<?> returnType = method.getReturnType();
            Type genericReturnType = method.getGenericReturnType();
            Class<?>[] parameterTypes = method.getParameterTypes();
            Type[] genericParameterTypes = method.getGenericParameterTypes();
            if (methodName.startsWith("get") && parameterTypes.length == 0 && !Void.TYPE.equals(returnType)) {
                name2 = CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_CAMEL, methodName.substring(3));
                this.getters.put(name2, method);
                this.addType(this.type, name2, returnType, genericReturnType);
                continue;
            }
            if (methodName.startsWith("is") && parameterTypes.length == 0 && !Void.TYPE.equals(returnType)) {
                name2 = CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_CAMEL, methodName.substring(2));
                this.getters.put(name2, method);
                this.addType(this.type, name2, returnType, genericReturnType);
                continue;
            }
            if (methodName.startsWith("set") && parameterTypes.length == 1 && Void.TYPE.equals(returnType) && methodName.startsWith("set")) {
                name2 = CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_CAMEL, methodName.substring(3));
                this.setters.put(name2, method);
                this.addType(this.type, name2, parameterTypes[0], genericParameterTypes[0]);
                continue;
            }
            this.methods.add(method);
        }
        ArrayList<AnnotatedMethod> typeMethods = new ArrayList<AnnotatedMethod>();
        HashMap<String, GetPropertyMethod> getPropertyMethods = new HashMap<String, GetPropertyMethod>();
        for (Map.Entry<String, Method> methodEntry : this.getters.entrySet()) {
            name = methodEntry.getKey();
            Method getter = methodEntry.getValue();
            Class<?> propertyType = this.types.get(name);
            Type genericType = this.genericTypes.get(name);
            GetPropertyMethod getPropertyMethod = new GetPropertyMethod(getter, name, propertyType, genericType);
            typeMethods.add(getPropertyMethod);
            getPropertyMethods.put(name, getPropertyMethod);
        }
        for (Map.Entry<String, Method> methodEntry : this.setters.entrySet()) {
            name = methodEntry.getKey();
            Method setter = methodEntry.getValue();
            GetPropertyMethod getPropertyMethod = (GetPropertyMethod)getPropertyMethods.get(name);
            Class<?> propertyType = this.types.get(name);
            Type genericType = this.genericTypes.get(name);
            SetPropertyMethod setPropertyMethod = new SetPropertyMethod(setter, getPropertyMethod, name, propertyType, genericType);
            typeMethods.add(setPropertyMethod);
        }
        for (Method method : this.methods) {
            typeMethods.add(new UserMethod(method));
        }
        return typeMethods;
    }

    private void addType(Class<?> declaringType, String name, Class<?> type, Type genericType) {
        Class<?> existingType = this.types.put(name, type);
        if (existingType != null && !existingType.equals(type)) {
            throw new XOException("Get and set methods for property '" + name + "' of type '" + declaringType.getName() + "' do not declare the same type: " + existingType.getName() + " <> " + type.getName());
        }
        Type existingGenericType = this.genericTypes.put(name, genericType);
        if (existingGenericType != null && !existingGenericType.equals(genericType)) {
            throw new XOException("Get and set methods for property '" + name + "' of type '" + declaringType.getName() + "' do not declare the same generic type: " + existingGenericType + " <> " + type.getName());
        }
    }
}

