/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.plugin.common.impl.scanner;

import com.buschmais.jqassistant.plugin.common.api.scanner.filesystem.FileResource;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;

public class BufferedFileResource
implements FileResource {
    private static final int DEFAULT_BUFFER_SIZE = 8192;
    private BufferStream bufferStream = null;
    private int bufferSize;
    private FileResource fileResource;

    public BufferedFileResource(FileResource fileResource) {
        this(fileResource, 8192);
    }

    public BufferedFileResource(FileResource fileResource, int bufferSize) {
        this.fileResource = fileResource;
        this.bufferSize = bufferSize;
    }

    @Override
    public InputStream createStream() throws IOException {
        if (this.bufferStream == null || !this.bufferStream.isReUsable()) {
            this.bufferStream = new BufferStream(this.fileResource.createStream(), this.bufferSize);
        }
        return this.bufferStream;
    }

    @Override
    public File getFile() throws IOException {
        return this.fileResource.getFile();
    }

    @Override
    public void close() throws IOException {
        this.fileResource.close();
    }

    private static class BufferStream
    extends BufferedInputStream {
        public BufferStream(InputStream inputStream, int bufferSize) {
            super(inputStream, bufferSize);
            this.mark(bufferSize);
        }

        @Override
        public void close() throws IOException {
            if (this.isReUsable()) {
                this.reset();
            } else {
                this.in.close();
            }
        }

        boolean isReUsable() {
            return this.markpos != -1;
        }
    }
}

