/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.plugin.common.api.scanner;

import com.buschmais.jqassistant.plugin.common.api.model.MD5Descriptor;
import java.io.IOException;
import java.io.InputStream;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.xml.bind.DatatypeConverter;

public class MD5DigestDelegate {
    private static final MD5DigestDelegate instance = new MD5DigestDelegate();
    private MessageDigest md5Digest;

    private MD5DigestDelegate() {
        try {
            this.md5Digest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("Cannot create message digest for MD5", e);
        }
    }

    public static MD5DigestDelegate getInstance() {
        return instance;
    }

    public <D extends MD5Descriptor> D digest(InputStream stream, DigestOperation<D> digestOperation) throws IOException {
        DigestInputStream digestInputStream = new DigestInputStream(stream, this.md5Digest);
        D md5Descriptor = digestOperation.execute(digestInputStream);
        String md5 = DatatypeConverter.printHexBinary((byte[])this.md5Digest.digest());
        md5Descriptor.setMd5(md5);
        return md5Descriptor;
    }

    public static interface DigestOperation<D extends MD5Descriptor> {
        public D execute(InputStream var1) throws IOException;
    }
}

