/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.plugin.common.api.scanner;

import com.buschmais.jqassistant.core.scanner.api.ScannerContext;
import com.buschmais.jqassistant.core.store.api.model.Descriptor;
import com.buschmais.jqassistant.plugin.common.api.model.FileDescriptor;
import com.buschmais.jqassistant.plugin.common.api.scanner.FileResolverStrategy;
import java.util.Deque;
import java.util.LinkedList;

public final class FileResolver {
    private Deque<FileResolverStrategy> resolverStrategies = new LinkedList<FileResolverStrategy>();

    public void push(FileResolverStrategy fileResolverStrategy) {
        this.resolverStrategies.push(fileResolverStrategy);
    }

    public void pop() {
        this.resolverStrategies.pop();
    }

    public FileDescriptor create(String path, ScannerContext context) {
        for (FileResolverStrategy fileResolverStrategy : this.resolverStrategies) {
            Descriptor fileDescriptor = fileResolverStrategy.match(path, context);
            if (fileDescriptor == null) continue;
            return this.toFileDescriptor(fileDescriptor, path, context);
        }
        return this.createFileDescriptor(path, context);
    }

    public FileDescriptor find(String path, ScannerContext context) {
        for (FileResolverStrategy fileResolverStrategy : this.resolverStrategies) {
            Descriptor descriptor = fileResolverStrategy.require(path, context);
            if (descriptor == null) continue;
            return this.toFileDescriptor(descriptor, path, context);
        }
        return this.createFileDescriptor(path, context);
    }

    private FileDescriptor toFileDescriptor(Descriptor descriptor, String path, ScannerContext context) {
        if (!(descriptor instanceof FileDescriptor)) {
            FileDescriptor fileDescriptor = (FileDescriptor)context.getStore().addDescriptorType(descriptor, FileDescriptor.class);
            fileDescriptor.setFileName(path);
            return fileDescriptor;
        }
        return (FileDescriptor)descriptor;
    }

    private FileDescriptor createFileDescriptor(String path, ScannerContext context) {
        FileDescriptor fileDescriptor = (FileDescriptor)context.getStore().create(FileDescriptor.class);
        fileDescriptor.setFileName(path);
        return fileDescriptor;
    }
}

