/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.plugin.common.api.scanner;

import com.buschmais.jqassistant.core.scanner.api.Scanner;
import com.buschmais.jqassistant.core.scanner.api.ScannerContext;
import com.buschmais.jqassistant.core.scanner.api.ScannerPlugin;
import com.buschmais.jqassistant.core.scanner.api.Scope;
import com.buschmais.jqassistant.core.store.api.model.Descriptor;
import com.buschmais.jqassistant.plugin.common.api.model.ArchiveDescriptor;
import com.buschmais.jqassistant.plugin.common.api.model.FileDescriptor;
import com.buschmais.jqassistant.plugin.common.api.scanner.AbstractScannerPlugin;
import com.buschmais.jqassistant.plugin.common.api.scanner.filesystem.FileResource;
import java.io.IOException;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ScannerPlugin.Requires(value={FileDescriptor.class})
public abstract class AbstractArchiveScannerPlugin<D extends ArchiveDescriptor>
extends AbstractScannerPlugin<FileResource, D> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractArchiveScannerPlugin.class);

    @Override
    public Class<? extends FileResource> getType() {
        return FileResource.class;
    }

    @Override
    public Class<? extends D> getDescriptorType() {
        return this.getTypeParameter(AbstractArchiveScannerPlugin.class, 0);
    }

    public boolean accepts(FileResource file, String path, Scope scope) throws IOException {
        return path.toLowerCase().endsWith(this.getExtension());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public D scan(FileResource file, String path, Scope currentScope, Scanner scanner) throws IOException {
        ScannerContext scannerContext = scanner.getContext();
        FileDescriptor fileDescriptor = (FileDescriptor)scannerContext.peek(FileDescriptor.class);
        ArchiveDescriptor archive = (ArchiveDescriptor)scannerContext.getStore().addDescriptorType((Descriptor)fileDescriptor, this.getDescriptorType());
        scannerContext.push(ArchiveDescriptor.class, (Object)archive);
        Scope archiveScope = this.createScope(currentScope, archive, scannerContext);
        try {
            ZipFile zipFile = new ZipFile(file.getFile());
            scanner.scan((Object)zipFile, path, archiveScope);
        }
        catch (ZipException e) {
            LOGGER.warn("Cannot read ZIP file '" + path + "'.", (Throwable)e);
        }
        finally {
            this.destroyScope(scannerContext);
            scannerContext.pop(ArchiveDescriptor.class);
        }
        return (D)archive;
    }

    protected abstract String getExtension();

    protected abstract Scope createScope(Scope var1, D var2, ScannerContext var3);

    protected abstract void destroyScope(ScannerContext var1);
}

