/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shell.kernel.apps.cypher;

import java.rmi.RemoteException;
import org.neo4j.cypher.export.CypherResultSubGraph;
import org.neo4j.cypher.export.DatabaseSubGraph;
import org.neo4j.cypher.export.SubGraph;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Result;
import org.neo4j.helpers.Exceptions;
import org.neo4j.shell.AppCommandParser;
import org.neo4j.shell.Continuation;
import org.neo4j.shell.Output;
import org.neo4j.shell.Session;
import org.neo4j.shell.ShellException;
import org.neo4j.shell.kernel.apps.cypher.Exporter;
import org.neo4j.shell.kernel.apps.cypher.Start;

public class Dump
extends Start {
    @Override
    public String getDescription() {
        return "Executes a Cypher query to export a subgraph. Usage: DUMP start <rest of query>;\nExample: DUMP start n = node({self}) MATCH n-[r]->m RETURN n,r,m;\nwhere {self} will be replaced with the current location in the graph.Please, note that the query must end with a semicolon. Other parameters are\ntaken from shell variables, see 'help export'.";
    }

    @Override
    protected Continuation exec(AppCommandParser parser, Session session, Output out) throws ShellException, RemoteException {
        if (parser.arguments().isEmpty()) {
            SubGraph graph = DatabaseSubGraph.from((GraphDatabaseService)this.getServer().getDb());
            this.export(graph, out);
            return Continuation.INPUT_COMPLETE;
        }
        AppCommandParser newParser = this.newParser(parser);
        return super.exec(newParser, session, out);
    }

    private AppCommandParser newParser(AppCommandParser parser) throws ShellException {
        String newLine = parser.getLineWithoutApp();
        AppCommandParser newParser = this.newParser(newLine);
        newParser.options().putAll(parser.options());
        return newParser;
    }

    private AppCommandParser newParser(String line) throws ShellException {
        try {
            return new AppCommandParser(this.getServer(), line);
        }
        catch (Exception e) {
            throw Exceptions.launderedException(ShellException.class, "Error parsing input " + line, e);
        }
    }

    private void export(SubGraph subGraph, Output out) throws RemoteException, ShellException {
        new Exporter(subGraph).export(out);
    }

    @Override
    protected void handleResult(Output out, Result result, long startTime) throws RemoteException, ShellException {
        SubGraph subGraph = CypherResultSubGraph.from((Result)result, (GraphDatabaseService)this.getServer().getDb(), (boolean)false);
        this.export(subGraph, out);
    }
}

