/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.xo.neo4j.impl.datastore;

import com.buschmais.xo.api.ResultIterator;
import com.buschmais.xo.api.XOException;
import com.buschmais.xo.neo4j.api.annotation.Cypher;
import com.buschmais.xo.neo4j.impl.datastore.AbstractNeo4jDatastoreSession;
import com.buschmais.xo.spi.datastore.DatastoreQuery;
import com.buschmais.xo.spi.datastore.DatastoreTransaction;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.Result;
import org.neo4j.graphdb.Transaction;

public class EmbeddedNeo4jDatastoreSession
extends AbstractNeo4jDatastoreSession<GraphDatabaseService> {
    private final DatastoreTransaction datastoreTransaction = new EmbeddedNeo4jDatastoreTransaction();

    public EmbeddedNeo4jDatastoreSession(GraphDatabaseService graphDatabaseService) {
        super(graphDatabaseService);
    }

    public DatastoreTransaction getDatastoreTransaction() {
        return this.datastoreTransaction;
    }

    public <QL extends Annotation> DatastoreQuery<QL> createQuery(Class<QL> queryLanguage) {
        if (Cypher.class.equals(queryLanguage)) {
            return new EmbeddedNeo4jCypherQuery();
        }
        throw new XOException("Unsupported query language: " + queryLanguage.getName());
    }

    private Object convertValue(Object value) {
        if (value instanceof Node) {
            return ((Node)value).getId();
        }
        if (value instanceof Relationship) {
            return ((Relationship)value).getId();
        }
        if (value instanceof Collection) {
            Collection collection = (Collection)value;
            ArrayList<Object> values = new ArrayList<Object>();
            for (Object o : collection) {
                values.add(this.convertValue(o));
            }
            return values;
        }
        return value;
    }

    public class EmbeddedNeo4jCypherQuery
    implements DatastoreQuery<Cypher> {
        public ResultIterator<Map<String, Object>> execute(Cypher expression, Map<String, Object> parameters) {
            return this.execute(expression.value(), parameters);
        }

        public ResultIterator<Map<String, Object>> execute(String expression, Map<String, Object> parameters) {
            final Result executionResult = EmbeddedNeo4jDatastoreSession.this.getGraphDatabaseService().execute(expression, this.translateParameters(parameters));
            final List columns = executionResult.columns();
            return new ResultIterator<Map<String, Object>>(){

                public boolean hasNext() {
                    return executionResult.hasNext();
                }

                public Map<String, Object> next() {
                    Map next = executionResult.next();
                    LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>(next.size(), 1.0f);
                    for (String column : columns) {
                        result.put(column, next.get(column));
                    }
                    return result;
                }

                public void remove() {
                    throw new XOException("Remove operation is not supported for query results.");
                }

                public void close() {
                    executionResult.close();
                }
            };
        }

        private Map<String, Object> translateParameters(Map<String, Object> parameters) {
            HashMap<String, Object> effectiveParameters = new HashMap<String, Object>();
            for (Map.Entry<String, Object> parameterEntry : parameters.entrySet()) {
                Object value = parameterEntry.getValue();
                value = EmbeddedNeo4jDatastoreSession.this.convertValue(value);
                effectiveParameters.put(parameterEntry.getKey(), value);
            }
            return effectiveParameters;
        }
    }

    private class EmbeddedNeo4jDatastoreTransaction
    implements DatastoreTransaction {
        private Transaction transaction;

        private EmbeddedNeo4jDatastoreTransaction() {
        }

        public void begin() {
            if (this.transaction != null) {
                throw new XOException("There is already an existing transaction.");
            }
            this.transaction = EmbeddedNeo4jDatastoreSession.this.getGraphDatabaseService().beginTx();
        }

        public void commit() {
            this.ensureTransaction();
            this.transaction.success();
            this.closeTransaction();
        }

        public void rollback() {
            this.ensureTransaction();
            this.transaction.failure();
            this.closeTransaction();
        }

        public boolean isActive() {
            return this.transaction != null;
        }

        private void ensureTransaction() {
            if (this.transaction == null) {
                throw new XOException("There is no existing transaction.");
            }
        }

        private void closeTransaction() {
            this.transaction.close();
            this.transaction = null;
        }
    }
}

