/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.xo.neo4j.impl.datastore;

import com.buschmais.xo.neo4j.impl.datastore.AbstractNeo4jDatastore;
import com.buschmais.xo.neo4j.impl.datastore.EmbeddedNeo4jDatastore;
import com.buschmais.xo.neo4j.impl.datastore.EmbeddedNeo4jDatastoreSession;
import com.buschmais.xo.neo4j.impl.datastore.metadata.IndexedPropertyMetadata;
import com.buschmais.xo.neo4j.impl.datastore.metadata.NodeMetadata;
import com.buschmais.xo.neo4j.impl.datastore.metadata.PropertyMetadata;
import com.buschmais.xo.spi.metadata.method.IndexedPropertyMethodMetadata;
import com.buschmais.xo.spi.metadata.method.PrimitivePropertyMethodMetadata;
import com.buschmais.xo.spi.metadata.type.EntityTypeMetadata;
import com.buschmais.xo.spi.metadata.type.TypeMetadata;
import java.util.Map;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.schema.IndexDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractEmbeddedNeo4jDatastore
extends AbstractNeo4jDatastore<EmbeddedNeo4jDatastoreSession> {
    private static final Logger LOGGER = LoggerFactory.getLogger(EmbeddedNeo4jDatastore.class);
    protected final GraphDatabaseService graphDatabaseService;

    public AbstractEmbeddedNeo4jDatastore(GraphDatabaseService graphDatabaseService) {
        this.graphDatabaseService = graphDatabaseService;
    }

    public EmbeddedNeo4jDatastoreSession createSession() {
        return new EmbeddedNeo4jDatastoreSession(this.graphDatabaseService);
    }

    public void init(Map<Class<?>, TypeMetadata> registeredMetadata) {
        try (Transaction transaction = this.graphDatabaseService.beginTx();){
            for (TypeMetadata typeMetadata : registeredMetadata.values()) {
                if (!(typeMetadata instanceof EntityTypeMetadata)) continue;
                EntityTypeMetadata entityTypeMetadata = (EntityTypeMetadata)typeMetadata;
                this.ensureIndex((EntityTypeMetadata<NodeMetadata>)entityTypeMetadata, (IndexedPropertyMethodMetadata<IndexedPropertyMetadata>)entityTypeMetadata.getIndexedProperty());
                this.ensureIndex((EntityTypeMetadata<NodeMetadata>)entityTypeMetadata, ((NodeMetadata)entityTypeMetadata.getDatastoreMetadata()).getUsingIndexedPropertyOf());
            }
            transaction.success();
        }
    }

    private void ensureIndex(EntityTypeMetadata<NodeMetadata> entityTypeMetadata, IndexedPropertyMethodMetadata<IndexedPropertyMetadata> indexedProperty) {
        IndexedPropertyMetadata datastoreMetadata;
        if (indexedProperty != null && (datastoreMetadata = (IndexedPropertyMetadata)indexedProperty.getDatastoreMetadata()).isCreate()) {
            Label label = ((NodeMetadata)entityTypeMetadata.getDatastoreMetadata()).getDiscriminator();
            PrimitivePropertyMethodMetadata propertyMethodMetadata = indexedProperty.getPropertyMethodMetadata();
            if (label != null && propertyMethodMetadata != null) {
                this.ensureIndex(label, (PrimitivePropertyMethodMetadata<PropertyMetadata>)propertyMethodMetadata, datastoreMetadata.isUnique());
            }
        }
    }

    private void ensureIndex(Label label, PrimitivePropertyMethodMetadata<PropertyMetadata> propertyMethodMetadata, boolean unique) {
        PropertyMetadata propertyMetadata = (PropertyMetadata)propertyMethodMetadata.getDatastoreMetadata();
        IndexDefinition index = this.findIndex(label, propertyMetadata.getName());
        if (index == null) {
            if (unique) {
                LOGGER.info("Creating constraint for label {} on property '{}'.", (Object)label, (Object)propertyMetadata.getName());
                this.graphDatabaseService.schema().constraintFor(label).assertPropertyIsUnique(propertyMetadata.getName()).create();
            } else {
                LOGGER.info("Creating index for label {} on property '{}'.", (Object)label, (Object)propertyMetadata.getName());
                this.graphDatabaseService.schema().indexFor(label).on(propertyMetadata.getName()).create();
            }
        }
    }

    private IndexDefinition findIndex(Label label, String propertyName) {
        Iterable indexes = this.graphDatabaseService.schema().getIndexes(label);
        for (IndexDefinition indexDefinition : indexes) {
            for (String key : indexDefinition.getPropertyKeys()) {
                if (!key.equals(propertyName)) continue;
                return indexDefinition;
            }
        }
        return null;
    }
}

