/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.plugin.xml.api.scanner;

import com.buschmais.jqassistant.plugin.common.api.scanner.filesystem.FileResource;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;

public class JAXBUnmarshaller<I extends FileResource, X> {
    private Class<X> rootElementType;
    private XMLInputFactory inputFactory;
    private JAXBContext jaxbContext;

    public JAXBUnmarshaller(Class<X> rootElementType) {
        this.rootElementType = rootElementType;
        this.inputFactory = XMLInputFactory.newInstance();
        this.inputFactory.setProperty("javax.xml.stream.supportDTD", false);
        try {
            this.jaxbContext = JAXBContext.newInstance((Class[])new Class[]{rootElementType});
        }
        catch (JAXBException e) {
            throw new IllegalStateException("Cannot create JAXB context for " + rootElementType.getName(), e);
        }
    }

    public X unmarshal(I item) throws IOException {
        JAXBElement rootElement;
        try (InputStream stream = item.createStream();){
            XMLEventReader xmlEventReader = this.inputFactory.createXMLEventReader(stream);
            Unmarshaller unmarshaller = this.jaxbContext.createUnmarshaller();
            rootElement = unmarshaller.unmarshal(xmlEventReader, this.rootElementType);
        }
        catch (JAXBException e) {
            throw new IOException("Cannot read XML document.", e);
        }
        catch (XMLStreamException e) {
            throw new IOException("Cannot read XML document.", e);
        }
        return (X)rootElement.getValue();
    }
}

