SELECT /*+ PARALLEL(AUTO) */
  NULL AS INDEX_CATALOG,
  OWNER AS INDEX_SCHEMA,
  INDEX_NAME AS INDEX_NAME,
  TABLE_NAME AS TABLE_NAME,
  CASE WHEN UNIQUENESS = 'UNIQUE' THEN 'YES' ELSE 'NO' END AS IS_UNIQUE,
  DBMS_METADATA.GET_DDL('INDEX',INDEX_NAME,OWNER) AS INDEX_DEFINITION
FROM
  ALL_INDEXES
WHERE
  OWNER NOT IN ('CTXSYS', 'DBSNMP', 'DMSYS', 'MDDATA', 'MDSYS', 'OLAPSYS', 'ORDPLUGINS', 'ORDSYS', 'OUTLN', 'SI_INFORMTN_SCHEMA', 'SYS', 'SYSMAN', 'SYSTEM', 'XDB')
  AND OWNER NOT LIKE 'APEX%'
ORDER BY
  INDEX_SCHEMA,
  TABLE_NAME,
  INDEX_NAME
