/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.plugin.jpa2.impl.scanner;

import com.buschmais.jqassistant.core.scanner.api.Scanner;
import com.buschmais.jqassistant.core.scanner.api.Scope;
import com.buschmais.jqassistant.core.store.api.Store;
import com.buschmais.jqassistant.core.store.api.model.Descriptor;
import com.buschmais.jqassistant.plugin.common.api.model.PropertyDescriptor;
import com.buschmais.jqassistant.plugin.common.api.scanner.AbstractScannerPlugin;
import com.buschmais.jqassistant.plugin.common.api.scanner.filesystem.FileResource;
import com.buschmais.jqassistant.plugin.java.api.model.TypeDescriptor;
import com.buschmais.jqassistant.plugin.java.api.scanner.JavaScope;
import com.buschmais.jqassistant.plugin.java.api.scanner.TypeResolver;
import com.buschmais.jqassistant.plugin.jpa2.api.model.PersistenceUnitDescriptor;
import com.buschmais.jqassistant.plugin.jpa2.api.model.PersistenceXmlDescriptor;
import com.buschmais.jqassistant.plugin.xml.api.model.XmlFileDescriptor;
import com.buschmais.jqassistant.plugin.xml.api.scanner.XmlScope;
import com.sun.java.xml.ns.persistence.ObjectFactory;
import com.sun.java.xml.ns.persistence.Persistence;
import com.sun.java.xml.ns.persistence.PersistenceUnitCachingType;
import com.sun.java.xml.ns.persistence.PersistenceUnitTransactionType;
import com.sun.java.xml.ns.persistence.PersistenceUnitValidationModeType;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;

public class PersistenceXmlScannerPlugin
extends AbstractScannerPlugin<FileResource, PersistenceXmlDescriptor> {
    private static final JAXBContext jaxbContext;

    public boolean accepts(FileResource item, String path, Scope scope) throws IOException {
        return JavaScope.CLASSPATH.equals((Object)scope) && "/META-INF/persistence.xml".equals(path) || "/WEB-INF/persistence.xml".equals(path);
    }

    public PersistenceXmlDescriptor scan(FileResource item, String path, Scope scope, Scanner scanner) throws IOException {
        Persistence persistence;
        try (InputStream stream = item.createStream();){
            Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            persistence = (Persistence)unmarshaller.unmarshal((Source)new StreamSource(stream), Persistence.class).getValue();
        }
        catch (JAXBException e) {
            throw new IOException("Cannot read model descriptor.", e);
        }
        Store store = scanner.getContext().getStore();
        XmlFileDescriptor xmlFileDescriptor = (XmlFileDescriptor)scanner.scan((Object)item, path, (Scope)XmlScope.DOCUMENT);
        PersistenceXmlDescriptor persistenceXmlDescriptor = (PersistenceXmlDescriptor)store.addDescriptorType((Descriptor)xmlFileDescriptor, PersistenceXmlDescriptor.class);
        persistenceXmlDescriptor.setVersion(persistence.getVersion());
        for (Persistence.PersistenceUnit persistenceUnit : persistence.getPersistenceUnit()) {
            PersistenceUnitCachingType sharedCacheMode;
            PersistenceUnitDescriptor persistenceUnitDescriptor = (PersistenceUnitDescriptor)store.create(PersistenceUnitDescriptor.class);
            persistenceUnitDescriptor.setName(persistenceUnit.getName());
            PersistenceUnitTransactionType transactionType = persistenceUnit.getTransactionType();
            if (transactionType != null) {
                persistenceUnitDescriptor.setTransactionType(transactionType.name());
            }
            persistenceUnitDescriptor.setDescription(persistenceUnit.getDescription());
            persistenceUnitDescriptor.setJtaDataSource(persistenceUnit.getJtaDataSource());
            persistenceUnitDescriptor.setNonJtaDataSource(persistenceUnit.getNonJtaDataSource());
            persistenceUnitDescriptor.setProvider(persistenceUnit.getProvider());
            PersistenceUnitValidationModeType validationMode = persistenceUnit.getValidationMode();
            if (validationMode != null) {
                persistenceUnitDescriptor.setValidationMode(validationMode.name());
            }
            if ((sharedCacheMode = persistenceUnit.getSharedCacheMode()) != null) {
                persistenceUnitDescriptor.setSharedCacheMode(sharedCacheMode.name());
            }
            for (String clazz : persistenceUnit.getClazz()) {
                TypeDescriptor typeDescriptor = ((TypeResolver)scanner.getContext().peek(TypeResolver.class)).resolve(clazz, scanner.getContext()).getTypeDescriptor();
                persistenceUnitDescriptor.getContains().add(typeDescriptor);
            }
            Persistence.PersistenceUnit.Properties properties = persistenceUnit.getProperties();
            if (properties != null) {
                for (Persistence.PersistenceUnit.Properties.Property property : properties.getProperty()) {
                    PropertyDescriptor propertyDescriptor = (PropertyDescriptor)store.create(PropertyDescriptor.class);
                    propertyDescriptor.setName(property.getName());
                    propertyDescriptor.setValue(property.getValue());
                    persistenceUnitDescriptor.getProperties().add(propertyDescriptor);
                }
            }
            persistenceXmlDescriptor.getContains().add(persistenceUnitDescriptor);
        }
        return persistenceXmlDescriptor;
    }

    static {
        try {
            jaxbContext = JAXBContext.newInstance((Class[])new Class[]{ObjectFactory.class});
        }
        catch (JAXBException e) {
            throw new IllegalStateException("Cannot create JAXB context.", e);
        }
    }
}

