/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.core.report.impl;

import com.buschmais.jqassistant.core.report.api.ReportTransformer;
import com.buschmais.jqassistant.core.report.api.ReportTransformerException;
import java.io.InputStream;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.URIResolver;
import javax.xml.transform.stream.StreamSource;

public class HtmlReportTransformer
implements ReportTransformer {
    @Override
    public void toEmbedded(Source source, Result target) throws ReportTransformerException {
        this.transform(source, target, HtmlReportTransformer.class.getResourceAsStream("/META-INF/xsl/jqassistant-report-embedded.xsl"));
    }

    @Override
    public void toStandalone(Source source, Result target) throws ReportTransformerException {
        this.transform(source, target, HtmlReportTransformer.class.getResourceAsStream("/META-INF/xsl/jqassistant-report-standalone.xsl"));
    }

    private void transform(Source source, Result target, InputStream template) throws ReportTransformerException {
        Transformer transformer;
        StreamSource xsl = new StreamSource(template);
        try {
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            transformerFactory.setURIResolver(new URIResolver(){

                @Override
                public Source resolve(String href, String base) throws TransformerException {
                    return new StreamSource(HtmlReportTransformer.class.getResourceAsStream(href));
                }
            });
            transformer = transformerFactory.newTransformer(xsl);
        }
        catch (TransformerConfigurationException e) {
            throw new ReportTransformerException("Cannot get transformer factory.", e);
        }
        try {
            transformer.transform(source, target);
        }
        catch (TransformerException e) {
            throw new ReportTransformerException("Cannot transform report.", e);
        }
    }
}

