/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.core.report.api;

import com.buschmais.jqassistant.core.report.api.Language;
import com.buschmais.jqassistant.core.report.api.LanguageElement;
import com.buschmais.jqassistant.core.store.api.model.Descriptor;
import com.buschmais.xo.spi.reflection.AnnotatedType;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;

public final class LanguageHelper {
    public static LanguageElement getLanguageElement(Descriptor descriptor) {
        for (Class<?> descriptorType : descriptor.getClass().getInterfaces()) {
            AnnotatedType annotatedType = new AnnotatedType(descriptorType);
            Annotation languageAnnotation = annotatedType.getByMetaAnnotation(Language.class);
            if (languageAnnotation == null) continue;
            return LanguageHelper.getAnnotationValue(languageAnnotation, "value", LanguageElement.class);
        }
        return null;
    }

    private static <T> T getAnnotationValue(Annotation annotation, String value, Class<T> expectedType) {
        Object elementValue;
        Method valueMethod;
        Class<? extends Annotation> annotationType = annotation.annotationType();
        try {
            valueMethod = annotationType.getDeclaredMethod(value, new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException("Cannot resolve required method '" + value + "()' for '" + annotationType + "'.");
        }
        try {
            elementValue = valueMethod.invoke((Object)annotation, new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            throw new IllegalStateException("Cannot invoke method value() for " + annotationType);
        }
        return elementValue != null ? (T)expectedType.cast(elementValue) : null;
    }
}

