/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.core.analysis.impl;

import com.buschmais.jqassistant.core.analysis.api.RuleSetReader;
import com.buschmais.jqassistant.core.analysis.api.rule.Concept;
import com.buschmais.jqassistant.core.analysis.api.rule.Constraint;
import com.buschmais.jqassistant.core.analysis.api.rule.DefaultRuleSet;
import com.buschmais.jqassistant.core.analysis.api.rule.Group;
import com.buschmais.jqassistant.core.analysis.api.rule.Metric;
import com.buschmais.jqassistant.core.analysis.api.rule.MetricGroup;
import com.buschmais.jqassistant.core.analysis.api.rule.RuleSet;
import com.buschmais.jqassistant.core.analysis.api.rule.Script;
import com.buschmais.jqassistant.core.analysis.api.rule.Severity;
import com.buschmais.jqassistant.core.analysis.api.rule.Template;
import com.buschmais.jqassistant.core.analysis.api.rule.source.RuleSource;
import com.buschmais.jqassistant.core.analysis.impl.XmlHelper;
import com.buschmais.jqassistant.core.analysis.rules.schema.v1.ConceptType;
import com.buschmais.jqassistant.core.analysis.rules.schema.v1.ConstraintType;
import com.buschmais.jqassistant.core.analysis.rules.schema.v1.GroupType;
import com.buschmais.jqassistant.core.analysis.rules.schema.v1.IncludedReferenceType;
import com.buschmais.jqassistant.core.analysis.rules.schema.v1.JqassistantRules;
import com.buschmais.jqassistant.core.analysis.rules.schema.v1.MetricGroupType;
import com.buschmais.jqassistant.core.analysis.rules.schema.v1.MetricType;
import com.buschmais.jqassistant.core.analysis.rules.schema.v1.ObjectFactory;
import com.buschmais.jqassistant.core.analysis.rules.schema.v1.ParameterDefinitionType;
import com.buschmais.jqassistant.core.analysis.rules.schema.v1.ParameterType;
import com.buschmais.jqassistant.core.analysis.rules.schema.v1.ParameterTypes;
import com.buschmais.jqassistant.core.analysis.rules.schema.v1.ReferenceType;
import com.buschmais.jqassistant.core.analysis.rules.schema.v1.ReferenceableType;
import com.buschmais.jqassistant.core.analysis.rules.schema.v1.ScriptType;
import com.buschmais.jqassistant.core.analysis.rules.schema.v1.SeverityEnumType;
import com.buschmais.jqassistant.core.analysis.rules.schema.v1.TemplateType;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XmlRuleSetReader
implements RuleSetReader {
    public static final String RULES_SCHEMA_LOCATION = "/META-INF/xsd/jqassistant-rules-1.0.xsd";
    public static final Schema SCHEMA = XmlHelper.getSchema("/META-INF/xsd/jqassistant-rules-1.0.xsd");
    private static final Logger LOGGER = LoggerFactory.getLogger(XmlRuleSetReader.class);
    private static final JAXBContext JAXB_CONTEXT;

    @Override
    public RuleSet read(List<? extends RuleSource> sources) {
        ArrayList<JqassistantRules> rules = new ArrayList<JqassistantRules>();
        for (RuleSource ruleSource : sources) {
            if (!ruleSource.isType(RuleSource.Type.XML)) continue;
            this.readXmlSource(rules, ruleSource);
        }
        return this.convert(rules);
    }

    private void readXmlSource(List<JqassistantRules> rules, RuleSource ruleSource) {
        try (InputStream inputStream = ruleSource.getInputStream();){
            Unmarshaller unmarshaller = JAXB_CONTEXT.createUnmarshaller();
            unmarshaller.setSchema(SCHEMA);
            LOGGER.debug("Reading rules from '{}'.", (Object)ruleSource.getId());
            StreamSource streamSource = new StreamSource(inputStream);
            JAXBElement jaxbElement = unmarshaller.unmarshal((Source)streamSource, JqassistantRules.class);
            rules.add((JqassistantRules)jaxbElement.getValue());
        }
        catch (IOException | JAXBException e) {
            throw new IllegalArgumentException("Cannot read rules from '" + ruleSource.getId() + "'.", e);
        }
    }

    private RuleSet convert(List<JqassistantRules> rules) {
        HashMap<String, Template> templates = new HashMap<String, Template>();
        HashMap<String, Concept> concepts = new HashMap<String, Concept>();
        HashMap<String, Constraint> constraints = new HashMap<String, Constraint>();
        HashMap<String, Group> groups = new HashMap<String, Group>();
        HashMap<String, MetricGroup> metricGroups = new HashMap<String, MetricGroup>();
        for (JqassistantRules rule : rules) {
            List<ReferenceableType> queryDefinitionOrConceptOrConstraint = rule.getTemplateOrConceptOrConstraint();
            for (ReferenceableType referenceableType : queryDefinitionOrConceptOrConstraint) {
                String id = referenceableType.getId();
                if (referenceableType instanceof TemplateType) {
                    Template template = this.createTemplate((TemplateType)referenceableType);
                    templates.put(id, template);
                    continue;
                }
                if (referenceableType instanceof ConceptType) {
                    Concept concept = this.createConcept(id, (ConceptType)referenceableType);
                    concepts.put(id, concept);
                    continue;
                }
                if (referenceableType instanceof ConstraintType) {
                    Constraint constraint = this.createConstraint(id, (ConstraintType)referenceableType);
                    constraints.put(id, constraint);
                    continue;
                }
                if (referenceableType instanceof GroupType) {
                    Group group = this.createGroup(id, (GroupType)referenceableType);
                    groups.put(id, group);
                    continue;
                }
                if (!(referenceableType instanceof MetricGroupType)) continue;
                MetricGroup metricGroup = this.createMetricGroup(id, (MetricGroupType)referenceableType);
                metricGroups.put(id, metricGroup);
            }
        }
        return new DefaultRuleSet(templates, concepts, constraints, groups, metricGroups);
    }

    private Template createTemplate(TemplateType referenceableType) {
        TemplateType templateType = referenceableType;
        HashMap parameterTypes = new HashMap();
        for (ParameterDefinitionType parameterDefinitionType : templateType.getParameterDefinition()) {
            Class parameterType;
            switch (parameterDefinitionType.getType()) {
                case INT: {
                    parameterType = Integer.class;
                    break;
                }
                case STRING: {
                    parameterType = String.class;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported parameter parameterDefinitionType " + (Object)((Object)parameterDefinitionType.getType()));
                }
            }
            parameterTypes.put(parameterDefinitionType.getName(), parameterType);
        }
        return new Template(templateType.getCypher(), parameterTypes);
    }

    private MetricGroup createMetricGroup(String id, MetricGroupType referenceableType) {
        MetricGroupType metricGroupType = referenceableType;
        LinkedHashMap<String, Metric> metrics = new LinkedHashMap<String, Metric>();
        for (MetricType metricType : metricGroupType.getMetric()) {
            String cypher = metricType.getCypher();
            String description = metricType.getDescription();
            Map<String, Class<?>> parameterTypes = this.getParameterTypes(metricType.getParameterDefinition());
            Set<String> requiresConcepts = this.getReferences(metricType.getRequiresConcept());
            Metric metric = new Metric(metricType.getId(), description, cypher, parameterTypes, requiresConcepts);
            metrics.put(metricType.getId(), metric);
        }
        return new MetricGroup(id, metricGroupType.getDescription(), metrics);
    }

    private Group createGroup(String id, GroupType referenceableType) {
        GroupType groupType = referenceableType;
        Map<String, Severity> includeConcepts = this.getReferences(groupType.getIncludeConcept(), Concept.DEFAULT_SEVERITY);
        Map<String, Severity> includeConstraints = this.getReferences(groupType.getIncludeConstraint(), Constraint.DEFAULT_SEVERITY);
        Set<String> includeGroups = this.getReferences(groupType.getIncludeGroup());
        return new Group(id, null, includeConcepts, includeConstraints, includeGroups);
    }

    private Concept createConcept(String id, ConceptType referenceableType) {
        ConceptType conceptType = referenceableType;
        String cypher = conceptType.getCypher();
        Script script = this.getScript(conceptType.getScript());
        ReferenceType useTemplate = conceptType.getUseTemplate();
        String templateId = useTemplate != null ? useTemplate.getRefId() : null;
        String description = conceptType.getDescription();
        Map<String, Object> parameters = this.getParameterValues(conceptType.getParameter());
        SeverityEnumType severityType = conceptType.getSeverity();
        Severity severity = this.getSeverity(severityType, Concept.DEFAULT_SEVERITY);
        List<ReferenceType> requiresConcept = conceptType.getRequiresConcept();
        Set<String> requiresConcepts = this.getReferences(requiresConcept);
        String deprecated = conceptType.getDeprecated();
        return new Concept(id, description, severity, deprecated, cypher, script, templateId, parameters, requiresConcepts);
    }

    private Constraint createConstraint(String id, ConstraintType referenceableType) {
        ConstraintType constraintType = referenceableType;
        String cypher = constraintType.getCypher();
        Script script = this.getScript(constraintType.getScript());
        ReferenceType useTemplate = constraintType.getUseTemplate();
        String templateId = useTemplate != null ? useTemplate.getRefId() : null;
        String description = constraintType.getDescription();
        Map<String, Object> parameters = this.getParameterValues(constraintType.getParameter());
        SeverityEnumType severityType = constraintType.getSeverity();
        Severity severity = this.getSeverity(severityType, Constraint.DEFAULT_SEVERITY);
        List<ReferenceType> requiresConcept = constraintType.getRequiresConcept();
        Set<String> requiresConcepts = this.getReferences(requiresConcept);
        String deprecated = constraintType.getDeprecated();
        return new Constraint(id, description, severity, deprecated, cypher, script, templateId, parameters, requiresConcepts);
    }

    private Script getScript(ScriptType scriptType) {
        if (scriptType != null) {
            return new Script(scriptType.getLanguage(), scriptType.getValue());
        }
        return null;
    }

    private Set<String> getReferences(List<? extends ReferenceType> referenceTypes) {
        HashSet<String> references = new HashSet<String>();
        for (ReferenceType referenceType : referenceTypes) {
            references.add(referenceType.getRefId());
        }
        return references;
    }

    private Map<String, Severity> getReferences(List<IncludedReferenceType> referenceType, Severity defaultConceptSeverity) {
        HashMap<String, Severity> references = new HashMap<String, Severity>();
        for (IncludedReferenceType includedRefereceType : referenceType) {
            Severity severity = this.getSeverity(includedRefereceType.getSeverity(), defaultConceptSeverity);
            references.put(includedRefereceType.getRefId(), severity);
        }
        return references;
    }

    private Map<String, Class<?>> getParameterTypes(List<ParameterDefinitionType> parameterDefinitionTypes) {
        HashMap parameters = new HashMap();
        for (ParameterDefinitionType parameterDefinitionType : parameterDefinitionTypes) {
            Class type;
            switch (parameterDefinitionType.getType()) {
                case INT: {
                    type = Integer.class;
                    break;
                }
                case STRING: {
                    type = String.class;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported parameter definition type" + parameterDefinitionType);
                }
            }
            parameters.put(parameterDefinitionType.getName(), type);
        }
        return parameters;
    }

    private Severity getSeverity(SeverityEnumType severityType, Severity defaultSeverity) {
        return severityType == null ? defaultSeverity : Severity.fromValue(severityType.value());
    }

    private Object getParameterType(ParameterTypes type, String stringValue) {
        Object value;
        switch (type) {
            case INT: {
                value = Integer.valueOf(stringValue);
                break;
            }
            case STRING: {
                value = stringValue;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported parameter types: " + (Object)((Object)type));
            }
        }
        return value;
    }

    private Map<String, Object> getParameterValues(List<ParameterType> parameter) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        for (ParameterType parameterType : parameter) {
            Object value = this.getParameterValue(parameterType.getType(), parameterType.getValue());
            parameters.put(parameterType.getName(), value);
        }
        return parameters;
    }

    private Object getParameterValue(ParameterTypes type, String stringValue) {
        Object value;
        switch (type) {
            case INT: {
                value = Integer.valueOf(stringValue);
                break;
            }
            case STRING: {
                value = stringValue;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported parameter types: " + (Object)((Object)type));
            }
        }
        return value;
    }

    static {
        try {
            JAXB_CONTEXT = JAXBContext.newInstance((Class[])new Class[]{ObjectFactory.class});
        }
        catch (JAXBException e) {
            throw new IllegalArgumentException("Cannot create JAXB context.", e);
        }
    }
}

