/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.core.analysis.impl;

import com.buschmais.jqassistant.core.analysis.api.AnalysisException;
import com.buschmais.jqassistant.core.analysis.api.AnalysisListener;
import com.buschmais.jqassistant.core.analysis.api.Console;
import com.buschmais.jqassistant.core.analysis.api.Result;
import com.buschmais.jqassistant.core.analysis.api.model.ConceptDescriptor;
import com.buschmais.jqassistant.core.analysis.api.rule.AbstractExecutableRule;
import com.buschmais.jqassistant.core.analysis.api.rule.AbstractRuleVisitor;
import com.buschmais.jqassistant.core.analysis.api.rule.Concept;
import com.buschmais.jqassistant.core.analysis.api.rule.Constraint;
import com.buschmais.jqassistant.core.analysis.api.rule.Group;
import com.buschmais.jqassistant.core.analysis.api.rule.RuleSet;
import com.buschmais.jqassistant.core.analysis.api.rule.Script;
import com.buschmais.jqassistant.core.analysis.api.rule.Severity;
import com.buschmais.jqassistant.core.analysis.api.rule.Template;
import com.buschmais.jqassistant.core.store.api.Store;
import com.buschmais.xo.api.Query;
import com.buschmais.xo.api.XOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;

public class AnalyzerVisitor
extends AbstractRuleVisitor {
    private RuleSet ruleSet;
    private Store store;
    private AnalysisListener reportWriter;
    private Console console;
    private ScriptEngineManager scriptEngineManager;

    public AnalyzerVisitor(RuleSet ruleSet, Store store, AnalysisListener reportWriter, Console console) {
        this.ruleSet = ruleSet;
        this.store = store;
        this.reportWriter = reportWriter;
        this.console = console;
        this.scriptEngineManager = new ScriptEngineManager();
    }

    @Override
    public void visitConcept(Concept concept, Severity severity) throws AnalysisException {
        try {
            this.store.beginTransaction();
            ConceptDescriptor conceptDescriptor = (ConceptDescriptor)this.store.find(ConceptDescriptor.class, concept.getId());
            if (conceptDescriptor == null) {
                this.console.info("Applying concept '" + concept.getId() + "'.");
                this.reportWriter.beginConcept(concept);
                this.reportWriter.setResult(this.execute(this.ruleSet, concept, severity));
                conceptDescriptor = (ConceptDescriptor)this.store.create(ConceptDescriptor.class);
                conceptDescriptor.setId(concept.getId());
                this.reportWriter.endConcept();
            }
            this.store.commitTransaction();
        }
        catch (XOException e) {
            this.store.rollbackTransaction();
            throw new AnalysisException("Cannot apply concept " + concept.getId(), e);
        }
    }

    @Override
    public void visitConstraint(Constraint constraint, Severity severity) throws AnalysisException {
        this.console.info("Validating constraint '" + constraint.getId() + "' with severity: '" + (Object)((Object)constraint.getSeverity()) + "'.");
        try {
            this.store.beginTransaction();
            this.reportWriter.beginConstraint(constraint);
            this.reportWriter.setResult(this.execute(this.ruleSet, constraint, severity));
            this.reportWriter.endConstraint();
            this.store.commitTransaction();
        }
        catch (XOException e) {
            this.store.rollbackTransaction();
            throw new AnalysisException("Cannot validate constraint " + constraint.getId(), e);
        }
    }

    @Override
    public void beforeGroup(Group group) throws AnalysisException {
        this.console.info("Executing group '" + group.getId() + "'");
        this.store.beginTransaction();
        this.reportWriter.beginGroup(group);
        this.store.commitTransaction();
    }

    @Override
    public void afterGroup(Group group) throws AnalysisException {
        this.store.beginTransaction();
        this.reportWriter.endGroup();
        this.store.commitTransaction();
    }

    private <T extends AbstractExecutableRule> Result<T> execute(RuleSet ruleSet, T executable, Severity severity) throws AnalysisException {
        Script script = executable.getScript();
        if (script != null) {
            return this.executeScript(script, executable, severity);
        }
        return this.executeCypher(ruleSet, executable, severity);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <T extends AbstractExecutableRule> Result<T> executeCypher(RuleSet ruleSet, T executable, Severity severity) throws AnalysisException {
        String cypher;
        String queryTemplateId = executable.getTemplateId();
        if (queryTemplateId != null) {
            Template template = ruleSet.getTemplates().get(queryTemplateId);
            if (template == null) {
                throw new AnalysisException("Cannot find query template " + queryTemplateId);
            }
            cypher = template.getCypher();
        } else {
            cypher = executable.getCypher();
        }
        ArrayList<Map<String, Object>> rows = new ArrayList<Map<String, Object>>();
        try (Query.Result<Query.Result.CompositeRowObject> compositeRowObjects = this.executeQuery(cypher, executable.getParameters());){
            ArrayList columns = null;
            for (Query.Result.CompositeRowObject rowObject : compositeRowObjects) {
                if (columns == null) {
                    columns = new ArrayList(rowObject.getColumns());
                }
                HashMap<String, Object> row = new HashMap<String, Object>();
                for (String columnName : columns) {
                    row.put(columnName, rowObject.get(columnName, Object.class));
                }
                rows.add(row);
            }
            Object object = new Result<T>(executable, severity, columns, rows);
            return object;
        }
        catch (Exception e) {
            throw new AnalysisException("Cannot execute query.", e);
        }
    }

    private <T extends AbstractExecutableRule> Result<T> executeScript(Script script, T executable, Severity severity) throws AnalysisException {
        Object scriptResult;
        String language = script.getLanguage();
        ScriptEngine scriptEngine = this.scriptEngineManager.getEngineByName(language);
        if (scriptEngine == null) {
            ArrayList<String> availableLanguages = new ArrayList<String>();
            for (ScriptEngineFactory factory : this.scriptEngineManager.getEngineFactories()) {
                availableLanguages.addAll(factory.getNames());
            }
            throw new AnalysisException("Cannot resolve scripting engine for '" + language + "', available languages are " + availableLanguages);
        }
        scriptEngine.put(ScriptVariable.STORE.getVariableName(), this.store);
        scriptEngine.put(ScriptVariable.RULE.getVariableName(), executable);
        scriptEngine.put(ScriptVariable.SEVERITY.getVariableName(), (Object)severity);
        try {
            scriptResult = scriptEngine.eval(script.getSource());
        }
        catch (ScriptException e) {
            throw new AnalysisException("Cannot execute script.", e);
        }
        if (!(scriptResult instanceof Result)) {
            throw new AnalysisException("Script returned an invalid result language, expected " + Result.class.getName() + " but got " + scriptResult);
        }
        return (Result)Result.class.cast(scriptResult);
    }

    private Query.Result<Query.Result.CompositeRowObject> executeQuery(String cypher, Map<String, Object> parameters) {
        this.console.debug("Executing query '" + cypher + "' with parameters [" + parameters + "]");
        return this.store.executeQuery(cypher, parameters);
    }

    private static enum ScriptVariable {
        STORE,
        RULE,
        SEVERITY;


        String getVariableName() {
            return this.name().toLowerCase();
        }
    }
}

