/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.core.analysis.api.rule;

import java.util.EnumSet;

public enum Severity {
    BLOCKER("blocker", 0),
    CRITICAL("critical", 1),
    MAJOR("major", 2),
    MINOR("minor", 3),
    INFO("info", 4);

    private final String value;
    private final Integer level;

    private Severity(String value, Integer level) {
        this.value = value;
        this.level = level;
    }

    public String getValue() {
        return this.value;
    }

    public Integer getLevel() {
        return this.level;
    }

    public static Severity fromValue(String value) {
        if (value == null) {
            return null;
        }
        for (Severity severity : EnumSet.allOf(Severity.class)) {
            if (!severity.value.equals(value)) continue;
            return severity;
        }
        return null;
    }

    public static Severity fromLevel(Integer level) {
        if (level == null) {
            return null;
        }
        for (Severity severity : EnumSet.allOf(Severity.class)) {
            if (!severity.level.equals(level)) continue;
            return severity;
        }
        return null;
    }

    public static String[] names() {
        int i = 0;
        String[] names = new String[Severity.values().length];
        for (Severity severity : Severity.values()) {
            names[i++] = severity.value;
        }
        return names;
    }
}

