/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.core.analysis.api;

import com.buschmais.jqassistant.core.analysis.api.rule.RuleSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class RuleSelection {
    private static final String GROUP_DEFAULT = "default";
    private List<String> conceptIds = new ArrayList<String>();
    private List<String> constraintIds = new ArrayList<String>();
    private List<String> groupIds = new ArrayList<String>();

    public List<String> getConceptIds() {
        return this.conceptIds;
    }

    public List<String> getConstraintIds() {
        return this.constraintIds;
    }

    public List<String> getGroupIds() {
        return this.groupIds;
    }

    public static class Builder {
        private RuleSelection ruleSelection = new RuleSelection();

        public static RuleSelection allOf(RuleSet ruleSet) {
            return Builder.newInstance().addGroupIds(ruleSet.getGroups().keySet()).addConstraintIds(ruleSet.getConstraints().keySet()).addConceptIds(ruleSet.getConcepts().keySet()).get();
        }

        public static RuleSelection newDefault(RuleSet ruleSet) {
            Builder builder = Builder.newInstance();
            if (ruleSet.getGroups().containsKey(RuleSelection.GROUP_DEFAULT)) {
                builder.addGroupId(RuleSelection.GROUP_DEFAULT).get();
            }
            return builder.get();
        }

        public static RuleSelection select(RuleSet ruleSet, Collection<String> groupIds, Collection<String> constraintIds, Collection<String> conceptIds) {
            Builder builder = Builder.newInstance().addGroupIds(groupIds).addConstraintIds(constraintIds).addConceptIds(conceptIds);
            if (builder.isEmpty()) {
                return Builder.newDefault(ruleSet);
            }
            return builder.get();
        }

        public static Builder newInstance() {
            return new Builder();
        }

        public Builder addConceptId(String id) {
            this.ruleSelection.conceptIds.add(id);
            return this;
        }

        public Builder addConceptIds(Collection<String> ids) {
            this.ruleSelection.conceptIds.addAll(ids);
            return this;
        }

        public Builder addConstraintId(String id) {
            this.ruleSelection.constraintIds.add(id);
            return this;
        }

        public Builder addConstraintIds(Collection<String> ids) {
            this.ruleSelection.constraintIds.addAll(ids);
            return this;
        }

        public Builder addGroupId(String id) {
            this.ruleSelection.getGroupIds().add(id);
            return this;
        }

        public Builder addGroupIds(Collection<String> ids) {
            this.ruleSelection.groupIds.addAll(ids);
            return this;
        }

        public RuleSelection get() {
            return this.ruleSelection;
        }

        public boolean isEmpty() {
            return this.ruleSelection.conceptIds.isEmpty() && this.ruleSelection.constraintIds.isEmpty() && this.ruleSelection.groupIds.isEmpty();
        }
    }
}

