/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.xo.neo4j.impl.datastore;

import com.buschmais.xo.api.ResultIterator;
import com.buschmais.xo.api.XOException;
import com.buschmais.xo.neo4j.api.annotation.Cypher;
import com.buschmais.xo.neo4j.impl.datastore.AbstractNeo4jDatastoreSession;
import com.buschmais.xo.spi.datastore.DatastoreQuery;
import com.buschmais.xo.spi.datastore.DatastoreTransaction;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.neo4j.rest.graphdb.RestAPI;
import org.neo4j.rest.graphdb.RestGraphDatabase;
import org.neo4j.rest.graphdb.entity.RestEntity;
import org.neo4j.rest.graphdb.query.RestCypherQueryEngine;
import org.neo4j.rest.graphdb.util.QueryResult;

public class RestNeo4jDatastoreSession
extends AbstractNeo4jDatastoreSession<RestGraphDatabase> {
    private final DatastoreTransaction transaction = new RestNeo4jDatastoreTransaction();

    public RestNeo4jDatastoreSession(RestGraphDatabase graphDatabaseService) {
        super(graphDatabaseService);
    }

    public DatastoreTransaction getDatastoreTransaction() {
        return this.transaction;
    }

    public <QL extends Annotation> DatastoreQuery<QL> createQuery(Class<QL> queryLanguage) {
        if (Cypher.class.equals(queryLanguage)) {
            return new RestNeo4jCypherQuery();
        }
        throw new XOException("Unsupported query language: " + queryLanguage.getName());
    }

    public class RestNeo4jCypherQuery
    implements DatastoreQuery<Cypher> {
        public ResultIterator<Map<String, Object>> execute(Cypher expression, Map<String, Object> parameters) {
            return this.execute(expression.value(), parameters);
        }

        public ResultIterator<Map<String, Object>> execute(String expression, Map<String, Object> parameters) {
            Map<String, Object> effectiveParameters = this.translateParameters(parameters);
            RestAPI restAPI = ((RestGraphDatabase)RestNeo4jDatastoreSession.this.getGraphDatabaseService()).getRestAPI();
            RestCypherQueryEngine restCypherQueryEngine = new RestCypherQueryEngine(restAPI);
            QueryResult queryResult = restCypherQueryEngine.query(expression, effectiveParameters);
            final Iterator iterator = queryResult.iterator();
            return new ResultIterator<Map<String, Object>>(){

                public boolean hasNext() {
                    return iterator.hasNext();
                }

                public Map<String, Object> next() {
                    return (Map)iterator.next();
                }

                public void remove() {
                    iterator.remove();
                }

                public void close() {
                }
            };
        }

        private Map<String, Object> translateParameters(Map<String, Object> parameters) {
            HashMap<String, Object> effectiveParameters = new HashMap<String, Object>();
            for (Map.Entry<String, Object> parameterEntry : parameters.entrySet()) {
                Object value = parameterEntry.getValue();
                if (value instanceof RestEntity) {
                    value = ((RestEntity)value).getId();
                }
                effectiveParameters.put(parameterEntry.getKey(), value);
            }
            return effectiveParameters;
        }
    }

    private class RestNeo4jDatastoreTransaction
    implements DatastoreTransaction {
        private RestNeo4jDatastoreTransaction() {
        }

        public void begin() {
        }

        public void commit() {
        }

        public void rollback() {
        }

        public boolean isActive() {
            return true;
        }
    }
}

